/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.integration.switchyard.jar;

import java.io.InputStream;
import java.util.Collection;
import java.util.TreeSet;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.Test;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactEnum;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ExtendedDocument;
import org.overlord.sramp.atom.archive.SrampArchive;
import org.overlord.sramp.atom.archive.SrampArchiveEntry;
import org.overlord.sramp.atom.archive.SrampArchiveException;
import org.overlord.sramp.atom.archive.expand.ZipToSrampArchive;
import org.overlord.sramp.integration.switchyard.expand.SwitchYardAppToSrampArchive;

public class SwitchYardAppToSrampArchiveTest {
    private static final String EXPECTED_ENTRIES = "META-INF/beans.xml\nMETA-INF/switchyard.xml\norg/switchyard/quickstarts/bean/service/InventoryService.class\norg/switchyard/quickstarts/bean/service/InventoryServiceBean.class\norg/switchyard/quickstarts/bean/service/Order.class\norg/switchyard/quickstarts/bean/service/OrderAck.class\norg/switchyard/quickstarts/bean/service/OrderService.class\norg/switchyard/quickstarts/bean/service/OrderServiceBean.class\nwsdl/OrderService.wsdl\n";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSwitchYardIntegration() throws Exception {
        InputStream stream = this.getClass().getResourceAsStream("switchyard-quickstart-bean-service.jar");
        SrampArchive archive = null;
        SwitchYardAppToSrampArchive sy2archive = null;
        try {
            sy2archive = new SwitchYardAppToSrampArchive(stream);
            archive = sy2archive.createSrampArchive();
            Assert.assertNotNull((Object)archive);
            this.doAllAssertions(archive);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly((InputStream)stream);
            SrampArchive.closeQuietly(archive);
            ZipToSrampArchive.closeQuietly((ZipToSrampArchive)sy2archive);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)stream);
        SrampArchive.closeQuietly((SrampArchive)archive);
        ZipToSrampArchive.closeQuietly((ZipToSrampArchive)sy2archive);
    }

    private void doAllAssertions(SrampArchive archive) throws SrampArchiveException {
        Collection entries = archive.getEntries();
        TreeSet<String> entryNames = new TreeSet<String>();
        for (SrampArchiveEntry srampArchiveEntry : entries) {
            entryNames.add(srampArchiveEntry.getPath());
        }
        StringBuilder buff = new StringBuilder();
        for (String entryName : entryNames) {
            buff.append(entryName).append("\n");
        }
        Assert.assertEquals((Object)EXPECTED_ENTRIES, (Object)buff.toString());
        SrampArchiveEntry entry = archive.getEntry("META-INF/switchyard.xml");
        Assert.assertNotNull((Object)entry);
        Assert.assertEquals((Object)"switchyard.xml", (Object)entry.getMetaData().getName());
        Assert.assertEquals((Object)BaseArtifactEnum.EXTENDED_DOCUMENT, (Object)entry.getMetaData().getArtifactType());
        ExtendedDocument switchyardXmlDoc = (ExtendedDocument)entry.getMetaData();
        Assert.assertEquals((Object)"SwitchYardXmlDocument", (Object)switchyardXmlDoc.getExtendedType());
        entry = archive.getEntry("org/switchyard/quickstarts/bean/service/InventoryService.class");
        Assert.assertNotNull((Object)entry);
        Assert.assertEquals((Object)"InventoryService.class", (Object)entry.getMetaData().getName());
        Assert.assertEquals((Object)BaseArtifactEnum.EXTENDED_DOCUMENT, (Object)entry.getMetaData().getArtifactType());
        ExtendedDocument inventoryServiceClass = (ExtendedDocument)entry.getMetaData();
        Assert.assertEquals((Object)"JavaClass", (Object)inventoryServiceClass.getExtendedType());
        entry = archive.getEntry("wsdl/OrderService.wsdl");
        Assert.assertNotNull((Object)entry);
        Assert.assertEquals((Object)"OrderService.wsdl", (Object)entry.getMetaData().getName());
        Assert.assertEquals((Object)BaseArtifactEnum.WSDL_DOCUMENT, (Object)entry.getMetaData().getArtifactType());
    }
}

