/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.integration.teiid.deriver;

import java.io.IOException;
import java.util.Collection;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ExtendedDocument;
import org.overlord.sramp.common.SrampModelUtils;
import org.overlord.sramp.common.derived.AbstractXmlDeriver;
import org.overlord.sramp.common.derived.LinkerContext;
import org.overlord.sramp.integration.teiid.Messages;
import org.overlord.sramp.integration.teiid.Utils;
import org.overlord.sramp.integration.teiid.model.TeiidArtifactType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class ModelDeriver
extends AbstractXmlDeriver {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModelDeriver.class);

    protected void derive(Collection<BaseArtifactType> derivedArtifacts, BaseArtifactType artifact, AbstractXmlDeriver.XmlDeriverContext xmlDeriverContext) throws IOException {
        LOGGER.debug("ModelDeriver:root element='{}' of artifact '{}'", (Object)xmlDeriverContext.getRootElement().getLocalName(), (Object)artifact.getName());
        if (!(artifact instanceof ExtendedDocument) || !TeiidArtifactType.MODEL.extendedType().equals(((ExtendedDocument)artifact).getExtendedType())) {
            throw new IllegalArgumentException(Messages.I18N.format("notModelArtifact", new Object[]{artifact.getName()}));
        }
        ExtendedDocument modelArtifact = (ExtendedDocument)artifact;
        try {
            if (!"XMI".equals(xmlDeriverContext.getRootElement().getLocalName())) {
                throw new IllegalArgumentException(Messages.I18N.format("missingModelRootElement", new Object[]{artifact.getName()}));
            }
            this.processNamespaces(xmlDeriverContext.getRootElement(), xmlDeriverContext);
            this.processModelAnnotation(derivedArtifacts, modelArtifact, xmlDeriverContext.getRootElement(), xmlDeriverContext.getXpath());
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public void link(LinkerContext context, BaseArtifactType vdbManifestArtifact, Collection<BaseArtifactType> derivedArtifacts) {
    }

    private void processModelAnnotation(Collection<BaseArtifactType> derivedArtifacts, ExtendedDocument modelArtifact, Element xmiElement, XPath xpath) throws Exception {
        Element annotationElement = (Element)this.query(xpath, xmiElement, Utils.getElementQueryString("mmcore:ModelAnnotation"), XPathConstants.NODE);
        if (annotationElement == null) {
            throw new IllegalArgumentException(Messages.I18N.format("missingModelAnnotationElement", new Object[]{modelArtifact.getName()}));
        }
        this.setProperty(modelArtifact, annotationElement, "xmi:uuid", "mmuuid");
        this.setProperty(modelArtifact, annotationElement, "primaryMetamodelUri", "primaryMetamodelUri");
        this.setProperty(modelArtifact, annotationElement, "modelType", "modelType");
        this.setProperty(modelArtifact, annotationElement, "ProducerName", "producerName");
        this.setProperty(modelArtifact, annotationElement, "ProducerVersion", "producerVersion");
        this.setProperty(modelArtifact, annotationElement, "maxSetSize", "maxSetSize");
        this.setProperty(modelArtifact, annotationElement, "nameInSource", "nameInSource");
        this.setProperty(modelArtifact, annotationElement, "description", "description");
        this.setProperty(modelArtifact, annotationElement, "visible", "visible");
    }

    private void processNamespaces(Element xmiElement, AbstractXmlDeriver.XmlDeriverContext xmlDeriverContext) {
        NamedNodeMap attributes = xmiElement.getAttributes();
        int numAttrs = attributes.getLength();
        for (int i = 0; i < numAttrs; ++i) {
            Node attr = attributes.item(i);
            if (!"xmlns".equals(attr.getPrefix())) continue;
            xmlDeriverContext.addNamespaceMapping(attr.getLocalName(), attr.getNodeValue());
            LOGGER.debug("ModelDeriver:adding namespace with prefix '{}' and URI '{}'", (Object)attr.getLocalName(), (Object)attr.getNodeValue());
        }
    }

    protected Object query(XPath xpath, Element context, String query, QName returnType) throws XPathExpressionException {
        LOGGER.debug("ModelDeriver:executing query '{}'", (Object)query);
        return super.query(xpath, context, query, returnType);
    }

    private void setProperty(ExtendedDocument modelArtifact, Element element, String attributeName, String propertyName) {
        String propValue = element.getAttribute(attributeName);
        SrampModelUtils.setCustomProperty((BaseArtifactType)modelArtifact, (String)propertyName, (String)propValue);
    }
}

