/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.integration;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.ServiceLoader;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactType;
import org.overlord.commons.services.ServiceRegistryUtil;
import org.overlord.sramp.common.ArtifactContent;
import org.overlord.sramp.common.ArtifactType;
import org.overlord.sramp.common.artifactbuilder.ArtifactBuilder;
import org.overlord.sramp.common.artifactbuilder.ArtifactBuilderProvider;
import org.overlord.sramp.common.artifactbuilder.BuiltInArtifactBuilderProvider;
import org.overlord.sramp.common.derived.ArtifactBuilderProviderAdapter;
import org.overlord.sramp.common.derived.DeriverProvider;
import org.overlord.sramp.integration.ArchiveContext;
import org.overlord.sramp.integration.artifacttypedetector.ArtifactTypeDetector;
import org.overlord.sramp.integration.artifacttypedetector.DefaultArtifactTypeDetector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtensionFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExtensionFactory.class);
    private static List<ArtifactTypeDetector> typeDetectors = new ArrayList<ArtifactTypeDetector>();
    private static List<ArtifactBuilderProvider> builderProviders = new ArrayList<ArtifactBuilderProvider>();

    private static void loadBuiltIn() {
        typeDetectors.add(new DefaultArtifactTypeDetector());
        builderProviders.add((ArtifactBuilderProvider)new BuiltInArtifactBuilderProvider());
    }

    private static void loadExtended() {
        File directory;
        Set extendedTypeDetectors = ServiceRegistryUtil.getServices(ArtifactTypeDetector.class);
        typeDetectors.addAll(extendedTypeDetectors);
        Set extendedBuilderProviders = ServiceRegistryUtil.getServices(ArtifactBuilderProvider.class);
        builderProviders.addAll(extendedBuilderProviders);
        LinkedList<URLClassLoader> loaders = new LinkedList<URLClassLoader>();
        String customDirPath = System.getProperty("sramp.extension.customDir");
        if (customDirPath != null && customDirPath.trim().length() > 0 && (directory = new File(customDirPath)).isDirectory()) {
            ArrayList<URL> arrayList = new ArrayList<URL>();
            Collection jarFiles = FileUtils.listFiles((File)directory, (String[])new String[]{"jar"}, (boolean)false);
            for (File jarFile : jarFiles) {
                try {
                    URL jarUrl = jarFile.toURI().toURL();
                    arrayList.add(jarUrl);
                }
                catch (MalformedURLException e) {}
            }
            URL[] urls = arrayList.toArray(new URL[arrayList.size()]);
            URLClassLoader jarCL = new URLClassLoader(urls, Thread.currentThread().getContextClassLoader());
            loaders.add(jarCL);
        }
        for (ClassLoader classLoader : loaders) {
            for (ArtifactTypeDetector typeDetector : ServiceLoader.load(ArtifactTypeDetector.class, classLoader)) {
                typeDetectors.add(typeDetector);
            }
            for (ArtifactBuilderProvider builderProvider : ServiceLoader.load(ArtifactBuilderProvider.class, classLoader)) {
                builderProviders.add(builderProvider);
            }
        }
    }

    @Deprecated
    private static void loadDerivers() {
        File directory;
        Set deriverProviders = ServiceRegistryUtil.getServices(DeriverProvider.class);
        for (DeriverProvider deriverProvider : deriverProviders) {
            builderProviders.add((ArtifactBuilderProvider)new ArtifactBuilderProviderAdapter(deriverProvider));
            LOGGER.warn("ArtifactDeriver and DeriverProvider have been deprecated and will be removed in a future release!  Please see ArtifactBuilder and ArtifactBuilderProvider!");
        }
        LinkedList<URLClassLoader> loaders = new LinkedList<URLClassLoader>();
        String customDirPath = System.getProperty("sramp.derivers.customDir");
        if (customDirPath != null && customDirPath.trim().length() > 0 && (directory = new File(customDirPath)).isDirectory()) {
            ArrayList<URL> arrayList = new ArrayList<URL>();
            Collection jarFiles = FileUtils.listFiles((File)directory, (String[])new String[]{"jar"}, (boolean)false);
            for (File jarFile : jarFiles) {
                try {
                    URL jarUrl = jarFile.toURI().toURL();
                    arrayList.add(jarUrl);
                }
                catch (MalformedURLException e) {}
            }
            URL[] urls = arrayList.toArray(new URL[arrayList.size()]);
            URLClassLoader jarCL = new URLClassLoader(urls, Thread.currentThread().getContextClassLoader());
            loaders.add(jarCL);
        }
        for (ClassLoader classLoader : loaders) {
            for (DeriverProvider deriverProvider : ServiceLoader.load(DeriverProvider.class, classLoader)) {
                builderProviders.add((ArtifactBuilderProvider)new ArtifactBuilderProviderAdapter(deriverProvider));
                LOGGER.warn("ArtifactDeriver and DeriverProvider have been deprecated and will be removed in a future release!  Please see ArtifactBuilder and ArtifactBuilderProvider!");
            }
        }
    }

    public static ArtifactType detect(ArtifactContent content) {
        for (ArtifactTypeDetector typeDetector : typeDetectors) {
            ArtifactType artifactType = typeDetector.detect(content);
            if (artifactType == null) continue;
            return artifactType;
        }
        return null;
    }

    public static ArtifactType detect(ArtifactContent content, ArchiveContext archiveContext) {
        for (ArtifactTypeDetector typeDetector : typeDetectors) {
            ArtifactType artifactType = typeDetector.detect(content, archiveContext);
            if (artifactType == null) continue;
            return artifactType;
        }
        return null;
    }

    public static boolean isArchive(ArtifactContent content) {
        for (ArtifactTypeDetector typeDetector : typeDetectors) {
            if (!typeDetector.isArchive(content)) continue;
            return true;
        }
        return false;
    }

    public static boolean allowExpansionFromArchive(ArtifactContent content, ArchiveContext archiveContext) {
        for (ArtifactTypeDetector typeDetector : typeDetectors) {
            if (!typeDetector.allowExpansionFromArchive(content, archiveContext)) continue;
            return true;
        }
        return false;
    }

    public static List<ArtifactBuilder> createArtifactBuilders(BaseArtifactType primaryArtifact, ArtifactContent artifactContent) {
        ArrayList<ArtifactBuilder> builders = new ArrayList<ArtifactBuilder>();
        for (ArtifactBuilderProvider builderProvider : builderProviders) {
            builders.addAll(builderProvider.createArtifactBuilders(primaryArtifact, artifactContent));
        }
        return builders;
    }

    static {
        ExtensionFactory.loadBuiltIn();
        ExtensionFactory.loadExtended();
        ExtensionFactory.loadDerivers();
        Collections.sort(typeDetectors, new ArtifactTypeDetectorComparator());
    }

    private static class ArtifactTypeDetectorComparator
    implements Comparator<ArtifactTypeDetector> {
        private ArtifactTypeDetectorComparator() {
        }

        @Override
        public int compare(ArtifactTypeDetector o1, ArtifactTypeDetector o2) {
            Integer p1 = o1.getPriority();
            Integer p2 = o2.getPriority();
            return p2.compareTo(p1);
        }
    }
}

