/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.karaf.commands;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.Properties;
import org.apache.felix.gogo.commands.Command;
import org.overlord.commons.codec.AesEncrypter;
import org.overlord.commons.karaf.commands.configure.AbstractConfigureFabricCommand;

@Command(scope="overlord:fabric:s-ramp", name="configure")
public class ConfigureFabricCommand
extends AbstractConfigureFabricCommand {
    private static String SRAMP_PROFILE_PATH = File.separator.equals("/") ? "overlord/sramp.profile" : "overlord\\sramp.profile";

    protected Object doExecute() throws Exception {
        super.doExecute();
        this.addHeaderProperties();
        this.updateSrampProperties();
        return null;
    }

    public String getSrampFabricProfilePath() {
        StringBuilder fuse_config_path = new StringBuilder();
        fuse_config_path.append(this.getFabricProfilesPath()).append(SRAMP_PROFILE_PATH).append(File.separator);
        return fuse_config_path.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateSrampProperties() throws Exception {
        String filePath = this.getSrampPropertiesFilePath();
        File srampFile = new File(filePath);
        if (srampFile.exists()) {
            FileInputStream in = null;
            try {
                in = new FileInputStream(filePath);
                Properties props = new Properties();
                props.load(in);
                FileOutputStream out = null;
                String aesEncryptedValue = AesEncrypter.encrypt((String)this.password);
                StringBuilder aesEncrypterBuilder = new StringBuilder();
                aesEncrypterBuilder.append("$\\{crypt:").append(aesEncryptedValue).append("\\}");
                aesEncryptedValue = aesEncrypterBuilder.toString();
                try {
                    out = new FileOutputStream(filePath);
                    props.setProperty("sramp.config.events.jms.password", aesEncryptedValue);
                    props.setProperty("sramp.config.events.jms.user", "srampjms");
                    props.store(out, null);
                }
                finally {
                    out.close();
                }
            }
            finally {
                in.close();
            }
        }
    }

    private String getSrampPropertiesFilePath() {
        StringBuilder fuse_config_path = new StringBuilder();
        fuse_config_path.append(this.getSrampFabricProfilePath()).append("sramp.properties");
        return fuse_config_path.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addHeaderProperties() throws Exception {
        String filePath = this.getOverlordPropertiesFilePath();
        Properties props = new Properties();
        InputStream is = null;
        try {
            is = new FileInputStream(new File(filePath));
            props.load(is);
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(filePath);
            props.setProperty("overlord.headerui.apps.s-ramp-ui.href", "/s-ramp-ui/");
            props.setProperty("overlord.headerui.apps.s-ramp-ui.label", "Repository");
            props.setProperty("overlord.headerui.apps.s-ramp-ui.primary-brand", "JBoss Overlord");
            props.setProperty("overlord.headerui.apps.s-ramp-ui.secondary-brand", "S-RAMP Repository");
            props.store(out, null);
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }
}

