/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.server.atom.workspaces;

import org.jboss.resteasy.plugins.providers.atom.Category;
import org.jboss.resteasy.plugins.providers.atom.app.AppAccept;
import org.jboss.resteasy.plugins.providers.atom.app.AppCategories;
import org.jboss.resteasy.plugins.providers.atom.app.AppCollection;
import org.jboss.resteasy.plugins.providers.atom.app.AppWorkspace;
import org.overlord.sramp.atom.SrampAtomConstants;
import org.overlord.sramp.common.ArtifactTypeEnum;

public abstract class AbstractWorkspace
extends AppWorkspace {
    private static final long serialVersionUID = 5198131343123300536L;
    private String hrefBase;

    public AbstractWorkspace(String hrefBase, String title) {
        if (hrefBase.endsWith("/")) {
            hrefBase = hrefBase.substring(0, hrefBase.length() - 1);
        }
        if (hrefBase.endsWith("/s-ramp")) {
            hrefBase = hrefBase.substring(0, hrefBase.length() - 8);
        }
        this.hrefBase = hrefBase;
        this.setTitle(title);
        this.configureWorkspace();
    }

    protected String url(String path) {
        return this.hrefBase + path;
    }

    protected AppCollection addCollection(String path, String title, String accept) {
        AppCollection collection = new AppCollection(this.url(path), title);
        collection.getAccept().add(new AppAccept(accept));
        this.getCollection().add(collection);
        return collection;
    }

    protected Category addCategory(AppCollection collection, String term, String label) {
        AppCategories categories = null;
        if (collection.getCategories().size() > 0) {
            categories = (AppCategories)collection.getCategories().get(0);
        } else {
            categories = new AppCategories();
            categories.setFixed(Boolean.valueOf(true));
            collection.getCategories().add(categories);
        }
        Category category = new Category();
        category.setScheme(SrampAtomConstants.X_S_RAMP_TYPE_URN);
        category.setTerm(term);
        category.setLabel(label);
        categories.getCategory().add(category);
        return category;
    }

    protected Category addTypeCategory(AppCollection collection, ArtifactTypeEnum type) {
        return this.addCategory(collection, type.getType(), type.getLabel());
    }

    protected abstract void configureWorkspace();
}

