/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.server.atom.services;

import java.net.URI;
import java.util.Date;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.jboss.resteasy.plugins.providers.atom.Entry;
import org.jboss.resteasy.plugins.providers.atom.Feed;
import org.jboss.resteasy.plugins.providers.atom.Person;
import org.jboss.resteasy.plugins.providers.atom.Source;
import org.overlord.sramp.atom.err.SrampAtomException;
import org.overlord.sramp.atom.mappers.OntologyToRdfMapper;
import org.overlord.sramp.atom.mappers.RdfToOntologyMapper;
import org.overlord.sramp.common.ontology.OntologyValidator;
import org.overlord.sramp.common.ontology.SrampOntology;
import org.overlord.sramp.repository.PersistenceFactory;
import org.overlord.sramp.repository.PersistenceManager;
import org.overlord.sramp.server.atom.services.AbstractResource;
import org.overlord.sramp.server.i18n.Messages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3._1999._02._22_rdf_syntax_ns_.RDF;

/*
 * Exception performing whole class analysis ignored.
 */
@Path(value="/s-ramp")
public class OntologyResource
extends AbstractResource {
    private static Logger logger = LoggerFactory.getLogger(OntologyResource.class);
    private static OntologyToRdfMapper o2rdf = new OntologyToRdfMapper();
    private static RdfToOntologyMapper rdf2o = new RdfToOntologyMapper();

    @POST
    @Path(value="ontology")
    @Consumes(value={"application/rdf+xml"})
    @Produces(value={"application/atom+xml;type=entry"})
    public Entry create(RDF rdf) throws SrampAtomException {
        SrampOntology ontology;
        try {
            ontology = new SrampOntology();
            rdf2o.map(rdf, ontology);
            OntologyValidator.validateOntology((SrampOntology)ontology);
        }
        catch (Exception e) {
            throw new SrampAtomException((Throwable)e);
        }
        try {
            PersistenceManager persistenceManager = PersistenceFactory.newInstance();
            ontology = persistenceManager.persistOntology(ontology);
            RDF responseRDF = new RDF();
            o2rdf.map(ontology, responseRDF);
            Entry entry = new Entry();
            entry.setId(new URI(ontology.getUuid()));
            entry.setPublished(ontology.getCreatedOn());
            entry.setUpdated(ontology.getLastModifiedOn());
            entry.getAuthors().add(new Person(ontology.getCreatedBy()));
            entry.setTitle(ontology.getLabel());
            entry.setSummary(ontology.getComment());
            entry.setAnyOtherJAXBObject((Object)responseRDF);
            return entry;
        }
        catch (Exception e) {
            OntologyResource.logError((Logger)logger, (String)Messages.i18n.format("ERROR_CREATING_ONTOLOGY", new Object[0]), (Throwable)e);
            throw new SrampAtomException((Throwable)e);
        }
    }

    @PUT
    @Path(value="ontology/{uuid}")
    @Consumes(value={"application/rdf+xml"})
    public void update(@PathParam(value="uuid") String uuid, RDF rdf) throws SrampAtomException {
        SrampOntology ontology;
        try {
            ontology = new SrampOntology();
            rdf2o.map(rdf, ontology);
            ontology.setUuid(uuid);
            OntologyValidator.validateOntology((SrampOntology)ontology);
        }
        catch (Exception e) {
            throw new SrampAtomException((Throwable)e);
        }
        try {
            PersistenceManager persistenceManager = PersistenceFactory.newInstance();
            persistenceManager.updateOntology(ontology);
        }
        catch (Exception e) {
            OntologyResource.logError((Logger)logger, (String)Messages.i18n.format("ERROR_UPDATING_ONTOLOGY", new Object[]{uuid}), (Throwable)e);
            throw new SrampAtomException((Throwable)e);
        }
    }

    @GET
    @Path(value="ontology/{uuid}")
    @Produces(value={"application/atom+xml;type=entry"})
    public Entry get(@PathParam(value="uuid") String uuid) throws SrampAtomException {
        try {
            PersistenceManager persistenceManager = PersistenceFactory.newInstance();
            SrampOntology ontology = persistenceManager.getOntology(uuid);
            RDF responseRDF = new RDF();
            o2rdf.map(ontology, responseRDF);
            Entry entry = new Entry();
            entry.setId(new URI(ontology.getUuid()));
            entry.setPublished(ontology.getCreatedOn());
            entry.setUpdated(ontology.getLastModifiedOn());
            entry.getAuthors().add(new Person(ontology.getCreatedBy()));
            entry.setTitle(ontology.getLabel());
            entry.setSummary(ontology.getComment());
            entry.setAnyOtherJAXBObject((Object)responseRDF);
            return entry;
        }
        catch (Exception e) {
            OntologyResource.logError((Logger)logger, (String)Messages.i18n.format("ERROR_GETTING_ONTOLOGY", new Object[]{uuid}), (Throwable)e);
            throw new SrampAtomException((Throwable)e);
        }
    }

    @DELETE
    @Path(value="ontology/{uuid}")
    public void delete(@PathParam(value="uuid") String uuid) throws SrampAtomException {
        try {
            PersistenceManager persistenceManager = PersistenceFactory.newInstance();
            persistenceManager.deleteOntology(uuid);
        }
        catch (Exception e) {
            OntologyResource.logError((Logger)logger, (String)Messages.i18n.format("ERROR_DELETING_ONTOLOGY", new Object[]{uuid}), (Throwable)e);
            throw new SrampAtomException((Throwable)e);
        }
    }

    @GET
    @Path(value="ontology")
    @Produces(value={"application/atom+xml;type=feed"})
    public Feed list() throws SrampAtomException {
        try {
            PersistenceManager persistenceManager = PersistenceFactory.newInstance();
            List ontologies = persistenceManager.getOntologies();
            Feed feed = new Feed();
            feed.setTitle("S-RAMP ontology feed");
            feed.setUpdated(new Date());
            for (SrampOntology ontology : ontologies) {
                Entry entry = new Entry();
                entry.setId(new URI(ontology.getUuid()));
                entry.setPublished(ontology.getCreatedOn());
                entry.setUpdated(ontology.getLastModifiedOn());
                entry.getAuthors().add(new Person(ontology.getCreatedBy()));
                entry.setTitle(ontology.getLabel());
                entry.setSummary(ontology.getComment());
                Source source = new Source();
                source.setBase(new URI(ontology.getBase()));
                source.setId(new URI(ontology.getId()));
                entry.setSource(source);
                feed.getEntries().add(entry);
            }
            return feed;
        }
        catch (Exception e) {
            OntologyResource.logError((Logger)logger, (String)Messages.i18n.format("ERROR_GETTING_ONTOLOGIES", new Object[0]), (Throwable)e);
            throw new SrampAtomException((Throwable)e);
        }
    }
}

