/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.server.mvn.services;

import org.apache.commons.lang.StringUtils;

public class MavenMetaData {
    public static final String SEPARATOR_FULL_NAME = ":";
    private String groupId = "";
    private String artifactId = "";
    private String version = "";
    private String type = "";
    private String classifier = "";
    private String parentType = "";
    private String fileName = "";
    private String snapshotId = "";

    public MavenMetaData(String groupId, String artifactId, String version, String type, String classifier, String snapshotId, String parentType, String fileName) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.type = type;
        this.classifier = classifier;
        this.parentType = parentType;
        this.fileName = fileName;
        this.snapshotId = snapshotId;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public boolean isArtifact() {
        return StringUtils.isNotBlank((String)this.groupId) && StringUtils.isNotBlank((String)this.fileName);
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public void setClassifier(String classifier) {
        this.classifier = classifier;
    }

    public String getParentType() {
        return this.parentType;
    }

    public void setParentType(String parentType) {
        this.parentType = parentType;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getSnapshotId() {
        return this.snapshotId;
    }

    public void setSnapshotId(String snapshotId) {
        this.snapshotId = snapshotId;
    }

    public String getParentFileName() {
        if (StringUtils.isBlank((String)this.parentType)) {
            return this.fileName;
        }
        return this.fileName.substring(0, this.fileName.lastIndexOf("."));
    }

    public boolean isSnapshotVersion() {
        return StringUtils.isNotBlank((String)this.version) && this.version.contains("SNAPSHOT");
    }

    public String getFullName() {
        StringBuilder builder = new StringBuilder("");
        builder.append(this.groupId).append(SEPARATOR_FULL_NAME);
        if (StringUtils.isNotBlank((String)this.version)) {
            builder.append(this.version);
        }
        builder.append(SEPARATOR_FULL_NAME);
        builder.append(this.fileName);
        return builder.toString();
    }

    public String toString() {
        return "MavenMetaData [groupId=" + this.groupId + ", artifactId=" + this.artifactId + ", version=" + this.version + ", type=" + this.type + ", classifier=" + this.classifier + ", parentType=" + this.parentType + ", fileName=" + this.fileName + "]";
    }
}

