/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.server.atom.services;

import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.util.HashSet;
import org.apache.commons.io.IOUtils;
import org.jboss.resteasy.client.ClientResponse;
import org.jboss.resteasy.plugins.providers.atom.Entry;
import org.jboss.resteasy.plugins.providers.atom.Feed;
import org.jboss.resteasy.test.TestPortProvider;
import org.junit.Assert;
import org.junit.Test;
import org.overlord.sramp.atom.client.ClientRequest;
import org.overlord.sramp.server.atom.services.AbstractResourceTest;
import org.s_ramp.xmlns._2010.s_ramp.Artifact;
import org.s_ramp.xmlns._2010.s_ramp.Property;
import org.s_ramp.xmlns._2010.s_ramp.XsdDocument;
import test.org.overlord.sramp.server.TestUtils;

public class FeedResourceTest
extends AbstractResourceTest {
    @Test
    public void testArtifactFeed() throws Exception {
        int numEntries = 10;
        HashSet<String> uuids = new HashSet<String>();
        for (int i = 0; i < numEntries; ++i) {
            Entry entry = this.doAddXsd(new String[0]);
            URI entryId = entry.getId();
            String uuid = entryId.toString();
            uuids.add(uuid);
        }
        ClientRequest request = new ClientRequest(TestPortProvider.generateURL((String)"/s-ramp/xsd/XsdDocument"));
        ClientResponse response = request.get(Feed.class);
        Feed feed = (Feed)response.getEntity();
        int uuidsFound = 0;
        for (Entry entry : feed.getEntries()) {
            String entryUuid = entry.getId().toString();
            if (!uuids.contains(entryUuid)) continue;
            ++uuidsFound;
        }
        Assert.assertEquals((long)numEntries, (long)uuidsFound);
        request = new ClientRequest(TestPortProvider.generateURL((String)"/s-ramp/xsd/XsdDocument?startPage=2&count=2"));
        response = request.get(Feed.class);
        feed = (Feed)response.getEntity();
        Assert.assertTrue((String)"Expected 2 entries.", (feed.getEntries().size() == 2 ? 1 : 0) != 0);
    }

    private Entry doAddXsd(String ... properties) throws Exception {
        ClientRequest request = new ClientRequest(TestPortProvider.generateURL((String)"/s-ramp/xsd/XsdDocument"));
        String artifactFileName = "PO.xsd";
        InputStream POXsd = ((Object)((Object)this)).getClass().getResourceAsStream("/sample-files/xsd/" + artifactFileName);
        String xmltext = TestUtils.convertStreamToString(POXsd);
        POXsd.close();
        request.header("Slug", (Object)artifactFileName);
        request.body("application/xml", (Object)xmltext);
        ClientResponse response = request.post(Entry.class);
        Entry entry = (Entry)response.getEntity();
        Artifact artifact = (Artifact)entry.getAnyOtherJAXBObject(Artifact.class, new Class[0]);
        Assert.assertEquals((Object)2376L, (Object)artifact.getXsdDocument().getContentSize());
        if (properties.length > 0) {
            Artifact srampArtifactWrapper = (Artifact)entry.getAnyOtherJAXBObject(Artifact.class, new Class[0]);
            XsdDocument xsdDocument = srampArtifactWrapper.getXsdDocument();
            for (int i = 0; i < properties.length; i += 2) {
                String propname = properties[i];
                String propvalue = properties[i + 1];
                Property prop = new Property();
                prop.setPropertyName(propname);
                prop.setPropertyValue(propvalue);
                xsdDocument.getProperty().add(prop);
            }
            String uuid = xsdDocument.getUuid();
            entry.setAnyOtherJAXBObject((Object)srampArtifactWrapper);
            request = new ClientRequest(TestPortProvider.generateURL((String)("/s-ramp/xsd/XsdDocument/" + uuid)));
            request.body("application/atom+xml;type=entry", (Object)entry);
            request.put(Void.class);
        }
        return entry;
    }

    @Test
    public void testExtendedTypeFeed() throws Exception {
        HashSet<String> pkgUuids = new HashSet<String>();
        for (int i = 0; i < 5; ++i) {
            Entry entry = this.doAddExtended("PkgDocument", "/sample-files/ext/defaultPackage.pkg");
            URI entryId = entry.getId();
            String uuid = entryId.toString();
            pkgUuids.add(uuid);
        }
        HashSet<String> bpmnUuids = new HashSet<String>();
        for (int i = 0; i < 3; ++i) {
            Entry entry = this.doAddExtended("BpmnDocument", "/sample-files/ext/Evaluation.bpmn");
            URI entryId = entry.getId();
            String uuid = entryId.toString();
            bpmnUuids.add(uuid);
        }
        ClientRequest request = new ClientRequest(TestPortProvider.generateURL((String)"/s-ramp/ext/PkgDocument"));
        ClientResponse response = request.get(Feed.class);
        Feed feed = (Feed)response.getEntity();
        HashSet<String> actualPkgUuids = new HashSet<String>();
        for (Entry entry : feed.getEntries()) {
            String entryUuid = entry.getId().toString();
            actualPkgUuids.add(entryUuid);
        }
        Assert.assertEquals(pkgUuids, actualPkgUuids);
        request = new ClientRequest(TestPortProvider.generateURL((String)"/s-ramp/ext/BpmnDocument"));
        response = request.get(Feed.class);
        feed = (Feed)response.getEntity();
        HashSet<String> actualBpmnUuids = new HashSet<String>();
        for (Entry entry : feed.getEntries()) {
            String entryUuid = entry.getId().toString();
            actualBpmnUuids.add(entryUuid);
        }
        Assert.assertEquals(bpmnUuids, actualBpmnUuids);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Entry doAddExtended(String extendedType, String testFilePath) throws Exception {
        ClientRequest request = new ClientRequest(TestPortProvider.generateURL((String)("/s-ramp/ext/" + extendedType)));
        File f = new File(testFilePath);
        String artifactFileName = f.getName();
        InputStream contentStream = ((Object)((Object)this)).getClass().getResourceAsStream(testFilePath);
        if (contentStream == null) {
            throw new NullPointerException("Failed to find: " + testFilePath);
        }
        try {
            Entry entry;
            request.header("Slug", (Object)artifactFileName);
            request.body("application/octet-stream", (Object)contentStream);
            ClientResponse response = request.post(Entry.class);
            Entry entry2 = entry = (Entry)response.getEntity();
            return entry2;
        }
        finally {
            IOUtils.closeQuietly((InputStream)contentStream);
        }
    }

    @Test
    public void testModelFeed() throws Exception {
        HashSet<String> xsdUuids = new HashSet<String>();
        for (int i = 0; i < 5; ++i) {
            Entry entry = this.doAddXsd(new String[0]);
            URI entryId = entry.getId();
            String uuid = entryId.toString();
            xsdUuids.add(uuid);
        }
        HashSet<String> pkgUuids = new HashSet<String>();
        for (int i = 0; i < 5; ++i) {
            Entry entry = this.doAddExtended("PkgDocument", "/sample-files/ext/defaultPackage.pkg");
            URI entryId = entry.getId();
            String uuid = entryId.toString();
            pkgUuids.add(uuid);
        }
        HashSet<String> bpmnUuids = new HashSet<String>();
        for (int i = 0; i < 3; ++i) {
            Entry entry = this.doAddExtended("BpmnDocument", "/sample-files/ext/Evaluation.bpmn");
            URI entryId = entry.getId();
            String uuid = entryId.toString();
            bpmnUuids.add(uuid);
        }
        ClientRequest request = new ClientRequest(TestPortProvider.generateURL((String)"/s-ramp/ext"));
        ClientResponse response = request.get(Feed.class);
        Feed feed = (Feed)response.getEntity();
        int uuidsFound = 0;
        for (Entry entry : feed.getEntries()) {
            String entryUuid = entry.getId().toString();
            if (!pkgUuids.contains(entryUuid) && !bpmnUuids.contains(entryUuid)) continue;
            ++uuidsFound;
        }
        Assert.assertEquals((long)8L, (long)uuidsFound);
        request = new ClientRequest(TestPortProvider.generateURL((String)"/s-ramp/xsd?startPage=1&count=2"));
        response = request.get(Feed.class);
        feed = (Feed)response.getEntity();
        Assert.assertTrue((String)"Expected 2 entries.", (feed.getEntries().size() == 2 ? 1 : 0) != 0);
    }
}

