/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.server.atom.services;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.Iterator;
import java.util.UUID;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.jboss.downloads.overlord.sramp._2013.auditing.AuditEntry;
import org.jboss.resteasy.plugins.providers.atom.Entry;
import org.jboss.resteasy.plugins.providers.atom.Feed;
import org.jboss.resteasy.plugins.providers.atom.Person;
import org.overlord.sramp.atom.err.SrampAtomException;
import org.overlord.sramp.common.SrampConstants;
import org.overlord.sramp.repository.AuditManager;
import org.overlord.sramp.repository.AuditManagerFactory;
import org.overlord.sramp.repository.audit.AuditEntrySet;
import org.overlord.sramp.server.atom.services.AbstractResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/s-ramp")
public class AuditResource
extends AbstractResource {
    private static Logger logger = LoggerFactory.getLogger(AuditResource.class);

    @POST
    @Path(value="audit/artifact/{artifactUuid}")
    @Consumes(value={"application/auditEntry+xml"})
    @Produces(value={"application/atom+xml;type=entry"})
    public Entry create(@PathParam(value="artifactUuid") String artifactUuid, AuditEntry auditEntry) throws SrampAtomException {
        try {
            AuditManager auditManager = AuditManagerFactory.newInstance();
            AuditEntry rval = auditManager.addAuditEntry(artifactUuid, auditEntry);
            return this.auditEntryToAtomEntry(rval);
        }
        catch (Throwable e) {
            AuditResource.logError(logger, "Error creating audit entry for: " + artifactUuid, e);
            throw new SrampAtomException(e);
        }
    }

    @GET
    @Path(value="audit/artifact/{artifactUuid}/{auditEntryUuid}")
    @Produces(value={"application/atom+xml;type=entry"})
    public Entry get(@PathParam(value="artifactUuid") String artifactUuid, @PathParam(value="auditEntryUuid") String auditEntryUuid) throws SrampAtomException {
        try {
            AuditManager auditManager = AuditManagerFactory.newInstance();
            AuditEntry auditEntry = auditManager.getArtifactAuditEntry(artifactUuid, auditEntryUuid);
            return this.auditEntryToAtomEntry(auditEntry);
        }
        catch (Throwable e) {
            AuditResource.logError(logger, "Error getting audit entries for artifact: " + artifactUuid, e);
            throw new SrampAtomException(e);
        }
    }

    @GET
    @Path(value="audit/artifact/{artifactUuid}")
    @Produces(value={"application/atom+xml;type=feed"})
    public Feed listForArtifact(@PathParam(value="artifactUuid") String artifactUuid, @QueryParam(value="startPage") Integer startPage, @QueryParam(value="startIndex") Integer startIndex, @QueryParam(value="count") Integer count) throws SrampAtomException {
        if (startIndex == null && startPage != null) {
            int c = count != null ? count : 100;
            startIndex = (startPage - 1) * c;
        }
        if (startIndex == null) {
            startIndex = 0;
        }
        if (count == null) {
            count = 100;
        }
        int startIdx = startIndex;
        int endIdx = startIdx + count - 1;
        try {
            AuditManager auditManager = AuditManagerFactory.newInstance();
            AuditEntrySet entries = auditManager.getArtifactAuditEntries(artifactUuid);
            return this.createAuditFeed(entries, startIdx, endIdx);
        }
        catch (Throwable e) {
            AuditResource.logError(logger, "Error getting audit entries for artifact: " + artifactUuid, e);
            throw new SrampAtomException(e);
        }
    }

    @GET
    @Path(value="audit/user/{username}")
    @Produces(value={"application/atom+xml;type=feed"})
    public Feed listForUser(@PathParam(value="username") String username, @QueryParam(value="startPage") Integer startPage, @QueryParam(value="startIndex") Integer startIndex, @QueryParam(value="count") Integer count) throws SrampAtomException {
        if (startIndex == null && startPage != null) {
            int c = count != null ? count : 100;
            startIndex = (startPage - 1) * c;
        }
        if (startIndex == null) {
            startIndex = 0;
        }
        if (count == null) {
            count = 100;
        }
        int startIdx = startIndex;
        int endIdx = startIdx + count - 1;
        try {
            AuditManager auditManager = AuditManagerFactory.newInstance();
            AuditEntrySet entries = auditManager.getUserAuditEntries(username);
            return this.createAuditFeed(entries, startIdx, endIdx);
        }
        catch (Throwable e) {
            AuditResource.logError(logger, "Error getting audit entries for user: " + username, e);
            throw new SrampAtomException(e);
        }
    }

    private Feed createAuditFeed(AuditEntrySet auditEntrySet, int fromRow, int toRow) throws Exception {
        int i;
        Feed feed = new Feed();
        feed.getExtensionAttributes().put(SrampConstants.SRAMP_PROVIDER_QNAME, "JBoss Overlord");
        feed.getExtensionAttributes().put(SrampConstants.SRAMP_ITEMS_PER_PAGE_QNAME, String.valueOf(toRow - fromRow + 1));
        feed.getExtensionAttributes().put(SrampConstants.SRAMP_START_INDEX_QNAME, String.valueOf(fromRow));
        feed.getExtensionAttributes().put(SrampConstants.SRAMP_TOTAL_RESULTS_QNAME, String.valueOf(auditEntrySet.size()));
        feed.setId(new URI(UUID.randomUUID().toString()));
        feed.setTitle("S-RAMP Audit Feed");
        feed.setSubtitle("All Audit Entries for Artifact");
        feed.setUpdated(new Date());
        Iterator iterator = auditEntrySet.iterator();
        for (i = 0; i < fromRow && iterator.hasNext(); ++i) {
            iterator.next();
        }
        for (i = fromRow; i <= toRow && iterator.hasNext(); ++i) {
            AuditEntry auditEntry = (AuditEntry)iterator.next();
            Entry entry = new Entry();
            entry.setId(new URI(auditEntry.getUuid()));
            entry.setPublished(auditEntry.getWhen().toGregorianCalendar().getTime());
            entry.setUpdated(auditEntry.getWhen().toGregorianCalendar().getTime());
            entry.getAuthors().add(new Person(auditEntry.getWho()));
            entry.setTitle(auditEntry.getType());
            entry.setSummary("");
            feed.getEntries().add(entry);
        }
        return feed;
    }

    private Entry auditEntryToAtomEntry(AuditEntry auditEntry) throws URISyntaxException {
        Entry entry = new Entry();
        entry.setId(new URI(auditEntry.getUuid()));
        entry.setPublished(auditEntry.getWhen().toGregorianCalendar().getTime());
        entry.setUpdated(auditEntry.getWhen().toGregorianCalendar().getTime());
        entry.getAuthors().add(new Person(auditEntry.getWho()));
        entry.setTitle(auditEntry.getType());
        entry.setSummary("");
        entry.setAnyOtherJAXBObject((Object)auditEntry);
        return entry;
    }
}

