/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.server.atom.services;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.util.Date;
import java.util.Iterator;
import java.util.Set;
import java.util.UUID;
import org.jboss.resteasy.plugins.providers.atom.Entry;
import org.jboss.resteasy.plugins.providers.atom.Feed;
import org.jboss.resteasy.plugins.providers.atom.Link;
import org.jboss.resteasy.plugins.providers.atom.Person;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactType;
import org.overlord.sramp.atom.MediaType;
import org.overlord.sramp.atom.err.SrampAtomException;
import org.overlord.sramp.atom.visitors.ArtifactToSummaryAtomEntryVisitor;
import org.overlord.sramp.common.SrampConstants;
import org.overlord.sramp.common.visitors.ArtifactVisitor;
import org.overlord.sramp.common.visitors.ArtifactVisitorHelper;
import org.overlord.sramp.repository.QueryManager;
import org.overlord.sramp.repository.QueryManagerFactory;
import org.overlord.sramp.repository.query.ArtifactSet;
import org.overlord.sramp.repository.query.SrampQuery;
import org.overlord.sramp.server.atom.services.AbstractResource;
import org.overlord.sramp.server.i18n.Messages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFeedResource
extends AbstractResource {
    private static Logger logger = LoggerFactory.getLogger(AbstractFeedResource.class);

    protected AbstractFeedResource() {
    }

    protected Feed createArtifactFeed(String query, Integer startIndex, Integer count, String orderBy, Boolean ascending, Set<String> propNames, String baseUrl) throws SrampAtomException {
        if (startIndex == null) {
            startIndex = 0;
        }
        if (count == null) {
            count = 100;
        }
        if (orderBy == null) {
            orderBy = "name";
        }
        if (ascending == null) {
            ascending = true;
        }
        ArtifactSet artifactSet = null;
        try {
            QueryManager queryManager = QueryManagerFactory.newInstance();
            SrampQuery srampQuery = queryManager.createQuery(query, orderBy, ascending.booleanValue());
            artifactSet = srampQuery.executeQuery();
            int startIdx = startIndex;
            int endIdx = startIdx + count - 1;
            Feed feed = this.createFeed(artifactSet, startIdx, endIdx, propNames, baseUrl);
            this.addPaginationLinks(feed, artifactSet, query, startIndex, count, orderBy, ascending, baseUrl);
            Feed feed2 = feed;
            return feed2;
        }
        catch (Throwable e) {
            AbstractFeedResource.logError(logger, Messages.i18n.format("Error trying to create an Artifact Feed.", new Object[0]), e);
            throw new SrampAtomException(e);
        }
        finally {
            if (artifactSet != null) {
                artifactSet.close();
            }
        }
    }

    private Feed createFeed(ArtifactSet artifactSet, int fromRow, int toRow, Set<String> propNames, String baseUrl) throws Exception {
        Feed feed = new Feed();
        feed.getExtensionAttributes().put(SrampConstants.SRAMP_PROVIDER_QNAME, "JBoss Overlord");
        feed.getExtensionAttributes().put(SrampConstants.SRAMP_ITEMS_PER_PAGE_QNAME, String.valueOf(toRow - fromRow + 1));
        feed.getExtensionAttributes().put(SrampConstants.SRAMP_START_INDEX_QNAME, String.valueOf(fromRow));
        feed.getExtensionAttributes().put(SrampConstants.SRAMP_TOTAL_RESULTS_QNAME, String.valueOf(artifactSet.size()));
        feed.setId(new URI(UUID.randomUUID().toString()));
        feed.setTitle("S-RAMP Feed");
        feed.setSubtitle("Ad Hoc query feed");
        feed.setUpdated(new Date());
        feed.getAuthors().add(new Person("anonymous"));
        Iterator iterator = artifactSet.iterator();
        for (int i = 0; i < fromRow && iterator.hasNext(); ++i) {
            iterator.next();
        }
        ArtifactToSummaryAtomEntryVisitor visitor = new ArtifactToSummaryAtomEntryVisitor(baseUrl, propNames);
        for (int i = fromRow; i <= toRow && iterator.hasNext(); ++i) {
            BaseArtifactType artifact = (BaseArtifactType)iterator.next();
            ArtifactVisitorHelper.visitArtifact((ArtifactVisitor)visitor, (BaseArtifactType)artifact);
            Entry entry = visitor.getAtomEntry();
            feed.getEntries().add(entry);
            visitor.reset();
        }
        return feed;
    }

    private void addPaginationLinks(Feed feed, ArtifactSet artifactSet, String query, int startIndex, int count, String orderBy, boolean ascending, String baseUrl) throws UnsupportedEncodingException {
        String hrefPattern = "%1$s?query=%2$s&page=%3$s&pageSize=%4$s&orderBy=%5$s&ascending=%6$s";
        String encodedQuery = URLEncoder.encode(query, "UTF-8");
        String firstHref = String.format(hrefPattern, baseUrl, encodedQuery, 0, String.valueOf(count), String.valueOf(orderBy), String.valueOf(ascending));
        int prevIndex = Math.max(0, startIndex - count);
        String prevHref = String.format(hrefPattern, baseUrl, encodedQuery, prevIndex, String.valueOf(count), String.valueOf(orderBy), String.valueOf(ascending));
        String nextHref = String.format(hrefPattern, baseUrl, encodedQuery, startIndex + count, String.valueOf(count), String.valueOf(orderBy), String.valueOf(ascending));
        Link first = new Link("first", firstHref, (javax.ws.rs.core.MediaType)MediaType.APPLICATION_ATOM_XML_FEED_TYPE);
        Link prev = new Link("prev", prevHref, (javax.ws.rs.core.MediaType)MediaType.APPLICATION_ATOM_XML_FEED_TYPE);
        Link next = new Link("next", nextHref, (javax.ws.rs.core.MediaType)MediaType.APPLICATION_ATOM_XML_FEED_TYPE);
        if (startIndex > 0) {
            feed.getLinks().add(first);
            feed.getLinks().add(prev);
        }
        if (artifactSet.iterator().hasNext()) {
            feed.getLinks().add(next);
        }
    }
}

