/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.shell.api;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import org.overlord.sramp.shell.api.Arguments;
import org.overlord.sramp.shell.api.InvalidCommandArgumentException;
import org.overlord.sramp.shell.api.ShellCommand;
import org.overlord.sramp.shell.api.ShellContext;

public abstract class AbstractShellCommand
implements ShellCommand {
    private ShellContext context;
    private Arguments arguments;
    private Writer writer;

    @Override
    public void setContext(ShellContext context) {
        this.context = context;
    }

    protected ShellContext getContext() {
        return this.context;
    }

    @Override
    public void setArguments(Arguments arguments) {
        this.arguments = arguments;
    }

    protected Arguments getArguments() {
        return this.arguments;
    }

    protected String requiredArgument(int argIndex, String message) throws InvalidCommandArgumentException {
        if (this.getArguments().size() <= argIndex) {
            throw new InvalidCommandArgumentException(argIndex, message);
        }
        return (String)this.getArguments().get(argIndex);
    }

    protected String optionalArgument(int argIndex) {
        return this.optionalArgument(argIndex, null);
    }

    protected String optionalArgument(int argIndex, String defaultValue) {
        if (this.getArguments().size() <= argIndex) {
            return defaultValue;
        }
        return (String)this.getArguments().get(argIndex);
    }

    @Override
    public void print(String formattedMessage, Object ... params) {
        String msg = String.format(formattedMessage, params);
        if (this.writer != null) {
            try {
                this.writer.write(msg);
                this.writer.write(10);
                this.writer.flush();
            }
            catch (IOException e) {}
        } else {
            System.out.println(msg);
        }
    }

    @Override
    public void setOutput(Writer output) {
        this.writer = output;
    }

    @Override
    public int tabCompletion(String lastArgument, List<CharSequence> candidates) {
        return -1;
    }
}

