/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.shell.commands.archive;

import java.io.File;
import javax.xml.namespace.QName;
import org.overlord.sramp.atom.archive.SrampArchive;
import org.overlord.sramp.shell.AbstractShellContextVariableLifecycleHandler;
import org.overlord.sramp.shell.api.AbstractShellCommand;
import org.overlord.sramp.shell.api.ShellContextVariableLifecycleHandler;

public class OpenArchiveCommand
extends AbstractShellCommand {
    public void printUsage() {
        this.print("archive:open <pathToArchive>", new Object[0]);
    }

    public void printHelp() {
        this.print("The 'open' operation opens an existing S-RAMP batch archive", new Object[0]);
        this.print("file.  Once open, the contents of the archive can be modified", new Object[0]);
        this.print("or just listed.", new Object[0]);
    }

    public void execute() throws Exception {
        String pathToArchive = this.requiredArgument(0, "Please supply the path to an S-RAMP batch archive file.");
        SrampArchive archive = null;
        QName varName = new QName("archive", "active-archive");
        archive = (SrampArchive)this.getContext().getVariable(varName);
        if (archive != null) {
            this.print("An S-RAMP archive is already open.  Please archive:close it before creating a new one.", new Object[0]);
            return;
        }
        File archiveFile = new File(pathToArchive);
        archive = new SrampArchive(archiveFile);
        this.getContext().setVariable(varName, (Object)archive, (ShellContextVariableLifecycleHandler)new AbstractShellContextVariableLifecycleHandler(){

            @Override
            public void onRemove(Object object) {
                SrampArchive.closeQuietly((SrampArchive)((SrampArchive)object));
            }

            @Override
            public void onContextDestroyed(Object object) {
                SrampArchive.closeQuietly((SrampArchive)((SrampArchive)object));
            }
        });
        this.print("S-RAMP batch archive opened from " + archiveFile.getCanonicalPath(), new Object[0]);
    }
}

