/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.shell.commands.core;

import javax.xml.namespace.QName;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactType;
import org.overlord.sramp.client.SrampAtomApiClient;
import org.overlord.sramp.common.ArtifactType;
import org.overlord.sramp.common.visitors.ArtifactVisitor;
import org.overlord.sramp.common.visitors.ArtifactVisitorHelper;
import org.overlord.sramp.shell.api.AbstractShellCommand;
import org.overlord.sramp.shell.util.PrintArtifactMetaDataVisitor;

public class RefreshMetaDataCommand
extends AbstractShellCommand {
    public void printUsage() {
        this.print("s-ramp:refreshMetaData", new Object[0]);
    }

    public void printHelp() {
        this.print("The 'refreshMetaData' command downloads the latest meta-data for", new Object[0]);
        this.print("a single artifact from the S-RAMP repository.  The artifact in", new Object[0]);
        this.print("question is the currently active artifact in the session.  If no", new Object[0]);
        this.print("artifact is currently active, then this command will fail.  This", new Object[0]);
        this.print("essentially re-downloads the meta-data for the current artifact", new Object[0]);
        this.print("and replaces any changes that may have existed there.", new Object[0]);
        this.print("", new Object[0]);
        this.print("Example usage:", new Object[0]);
        this.print(">  s-ramp:refreshMetaData", new Object[0]);
    }

    public void execute() throws Exception {
        QName clientVarName = new QName("s-ramp", "client");
        QName artifactVarName = new QName("s-ramp", "artifact");
        SrampAtomApiClient client = (SrampAtomApiClient)this.getContext().getVariable(clientVarName);
        if (client == null) {
            this.print("No S-RAMP repository connection is currently open.", new Object[0]);
            return;
        }
        BaseArtifactType artifact = (BaseArtifactType)this.getContext().getVariable(artifactVarName);
        if (artifact == null) {
            this.print("No active S-RAMP artifact exists.  Use s-ramp:getMetaData or s-ramp:upload.", new Object[0]);
            return;
        }
        try {
            ArtifactType type = ArtifactType.valueOf((BaseArtifactType)artifact);
            BaseArtifactType metaData = client.getArtifactMetaData(type, artifact.getUuid());
            this.getContext().setVariable(artifactVarName, (Object)metaData);
            this.print("Successfully refreshed meta-data for artifact '%1$s'.", new Object[]{artifact.getName()});
            this.print("Meta Data for: " + artifact.getUuid(), new Object[0]);
            this.print("--------------", new Object[0]);
            PrintArtifactMetaDataVisitor visitor = new PrintArtifactMetaDataVisitor();
            ArtifactVisitorHelper.visitArtifact((ArtifactVisitor)visitor, (BaseArtifactType)artifact);
        }
        catch (Exception e) {
            this.print("FAILED to update the artifact.", new Object[0]);
            this.print("\t" + e.getMessage(), new Object[0]);
        }
    }
}

