/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.shell.commands.ontology;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.overlord.sramp.client.SrampAtomApiClient;
import org.overlord.sramp.shell.api.AbstractShellCommand;
import org.overlord.sramp.shell.api.Arguments;
import org.overlord.sramp.shell.api.ShellContext;
import org.overlord.sramp.shell.api.SimpleShellContext;
import org.overlord.sramp.shell.util.FileNameCompleter;

public class UploadOntologyCommand
extends AbstractShellCommand {
    public void printUsage() {
        this.print("ontology:upload <pathToOntologyFile>", new Object[0]);
    }

    public void printHelp() {
        this.print("The 'upload' command uploads a new OWL ontology file to the", new Object[0]);
        this.print("S-RAMP repository.  This makes the classes defined in the OWL", new Object[0]);
        this.print("ontology available for use as classifications on artifacts.", new Object[0]);
        this.print("", new Object[0]);
        this.print("Example usage:", new Object[0]);
        this.print(">  ontology:upload /home/uname/files/regions.owl.xml", new Object[0]);
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 2) {
            throw new Exception("Usage: " + UploadOntologyCommand.class + " [-file | -resource] [<filePath> | <resourcePath>]");
        }
        String type = args[0];
        String path = args[1];
        StringBuilder argLine = new StringBuilder();
        boolean isResource = "-resource".equals(type);
        if (isResource) {
            URL url = UploadOntologyCommand.class.getResource(path);
            if (url == null) {
                throw new Exception("Could not find " + path + " on the classpath");
            }
            argLine.append(url.toExternalForm());
        } else {
            File file = new File(path);
            if (!file.isFile()) {
                throw new FileNotFoundException(path);
            }
            argLine.append(file.getCanonicalPath());
        }
        SrampAtomApiClient client = new SrampAtomApiClient("http://localhost:8080/s-ramp-server");
        QName clientVarName = new QName("s-ramp", "client");
        SimpleShellContext context = new SimpleShellContext();
        context.setVariable(clientVarName, (Object)client);
        UploadOntologyCommand cmd = new UploadOntologyCommand();
        cmd.setArguments(new Arguments(argLine.toString()));
        cmd.setContext((ShellContext)context);
        cmd.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws Exception {
        String filePathArg = this.requiredArgument(0, "Please specify a path to a local ontology file.");
        QName clientVarName = new QName("s-ramp", "client");
        SrampAtomApiClient client = (SrampAtomApiClient)this.getContext().getVariable(clientVarName);
        if (client == null) {
            this.print("No S-RAMP repository connection is currently open.", new Object[0]);
            return;
        }
        InputStream content = null;
        try {
            File file = new File(filePathArg);
            if (file.exists()) {
                content = FileUtils.openInputStream((File)file);
            } else {
                URL url = ((Object)((Object)this)).getClass().getResource(filePathArg);
                if (url != null) {
                    this.print("Reading from ontology file " + url.toExternalForm(), new Object[0]);
                    content = url.openStream();
                } else {
                    this.print("ERROR: Cannot find " + filePathArg, new Object[0]);
                }
            }
            client.uploadOntology(content);
            this.print("Successfully uploaded a new ontology to the S-RAMP repository.", new Object[0]);
        }
        catch (Exception e) {
            try {
                this.print("FAILED to upload an artifact.", new Object[0]);
                this.print("\t" + e.getMessage(), new Object[0]);
                IOUtils.closeQuietly((InputStream)content);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(content);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)content);
        }
        IOUtils.closeQuietly((InputStream)content);
        this.print("**********************************************************************", new Object[0]);
    }

    public int tabCompletion(String lastArgument, List<CharSequence> candidates) {
        if (lastArgument == null) {
            lastArgument = "";
        }
        if (this.getArguments().isEmpty()) {
            FileNameCompleter delegate = new FileNameCompleter();
            return delegate.complete(lastArgument, lastArgument.length(), candidates);
        }
        return -1;
    }
}

