/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.shell;

import java.io.BufferedReader;
import java.io.Console;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.overlord.sramp.shell.AbstractShellCommandReader;
import org.overlord.sramp.shell.ShellCommandFactory;
import org.overlord.sramp.shell.ShellContextImpl;
import org.overlord.sramp.shell.i18n.Messages;

public class FileShellCommandReader
extends AbstractShellCommandReader {
    private String filePath;
    private BufferedReader fileReader;

    public FileShellCommandReader(ShellCommandFactory factory, ShellContextImpl context, String filePath) {
        super(factory, context);
        this.filePath = filePath;
    }

    @Override
    public void open() throws IOException {
        File file = new File(this.filePath);
        if (!file.isFile()) {
            throw new FileNotFoundException(this.filePath);
        }
        this.fileReader = new BufferedReader(new InputStreamReader(FileUtils.openInputStream((File)file)));
    }

    @Override
    protected String readLine() throws IOException {
        String line = null;
        while ((line = this.fileReader.readLine()) != null && (line.startsWith("#") || line.trim().length() == 0)) {
        }
        return line;
    }

    @Override
    public void close() throws IOException {
        IOUtils.closeQuietly((Reader)this.fileReader);
    }

    @Override
    public boolean isBatch() {
        return true;
    }

    @Override
    public String promptForInput(String prompt) {
        Console console = System.console();
        if (console != null) {
            return console.readLine(prompt, new Object[0]);
        }
        throw new RuntimeException(Messages.i18n.format("FileShellCommandReader.NoConsole", new Object[0]));
    }

    @Override
    public String promptForPassword(String prompt) {
        Console console = System.console();
        if (console != null) {
            return new String(console.readPassword(prompt, new Object[0]));
        }
        throw new RuntimeException(Messages.i18n.format("FileShellCommandReader.NoConsole", new Object[0]));
    }
}

