/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.shell.commands.archive;

import java.util.Collection;
import javax.xml.namespace.QName;
import org.overlord.sramp.atom.archive.SrampArchive;
import org.overlord.sramp.atom.archive.SrampArchiveEntry;
import org.overlord.sramp.shell.BuiltInShellCommand;
import org.overlord.sramp.shell.i18n.Messages;

public class ListArchiveCommand
extends BuiltInShellCommand {
    public boolean execute() throws Exception {
        QName varName = new QName("archive", "active-archive");
        SrampArchive archive = (SrampArchive)this.getContext().getVariable(varName);
        if (archive == null) {
            this.print(Messages.i18n.format("NO_ARCHIVE_OPEN", new Object[0]), new Object[0]);
            return false;
        }
        Collection entries = archive.getEntries();
        this.print(Messages.i18n.format("ENTRY_PATH", new Object[0]), new Object[0]);
        this.print("  ----------", new Object[0]);
        for (SrampArchiveEntry entry : entries) {
            String modifier = null;
            modifier = entry.hasContent() ? "  C " : "  E ";
            this.print(modifier + entry.getPath(), new Object[0]);
        }
        this.print("  ----------", new Object[0]);
        this.print(Messages.i18n.format("ENTRY_LIST_SUMMARY", new Object[]{entries.size()}), new Object[0]);
        return true;
    }
}

