/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.shell.commands.archive;

import java.io.File;
import javax.xml.namespace.QName;
import org.apache.commons.io.FileUtils;
import org.overlord.sramp.atom.archive.SrampArchive;
import org.overlord.sramp.shell.BuiltInShellCommand;
import org.overlord.sramp.shell.i18n.Messages;

public class PackArchiveCommand
extends BuiltInShellCommand {
    public boolean execute() throws Exception {
        String outputLocationArg = this.requiredArgument(0, Messages.i18n.format("PackArchive.InvalidArgMsg.OutputLocation", new Object[0]));
        QName varName = new QName("archive", "active-archive");
        SrampArchive archive = (SrampArchive)this.getContext().getVariable(varName);
        if (archive == null) {
            this.print(Messages.i18n.format("NO_ARCHIVE_OPEN", new Object[0]), new Object[0]);
            return false;
        }
        File outputFile = new File(outputLocationArg);
        if (outputFile.exists()) {
            this.print(Messages.i18n.format("PackArchive.OutputLocAlreadyExists", new Object[0]), new Object[0]);
        }
        if (!outputFile.getParentFile().exists()) {
            outputFile.mkdirs();
        }
        File packedFile = archive.pack();
        FileUtils.copyFile((File)packedFile, (File)outputFile);
        this.print(Messages.i18n.format("PackArchive.Packaged", new Object[]{outputFile.getCanonicalPath()}), new Object[0]);
        return true;
    }
}

