/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.shell.commands.archive;

import javax.xml.namespace.QName;
import org.overlord.sramp.atom.archive.SrampArchive;
import org.overlord.sramp.client.SrampAtomApiClient;
import org.overlord.sramp.shell.BuiltInShellCommand;
import org.overlord.sramp.shell.i18n.Messages;

public class UploadArchiveCommand
extends BuiltInShellCommand {
    public boolean execute() throws Exception {
        QName clientVarName = new QName("s-ramp", "client");
        SrampAtomApiClient client = (SrampAtomApiClient)this.getContext().getVariable(clientVarName);
        if (client == null) {
            this.print(Messages.i18n.format("MissingSRAMPConnection", new Object[0]), new Object[0]);
            return false;
        }
        QName varName = new QName("archive", "active-archive");
        SrampArchive archive = (SrampArchive)this.getContext().getVariable(varName);
        if (archive == null) {
            this.print(Messages.i18n.format("NO_ARCHIVE_OPEN", new Object[0]), new Object[0]);
            return false;
        }
        try {
            client.uploadBatch(archive);
            this.getContext().removeVariable(varName);
            this.print(Messages.i18n.format("UploadArchive.Success", new Object[0]), new Object[0]);
        }
        catch (Exception e) {
            this.print(Messages.i18n.format("UploadArchive.Failure", new Object[0]), new Object[0]);
            this.print("\t" + e.getMessage(), new Object[0]);
            return false;
        }
        return true;
    }
}

