/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.shell.commands.archive;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactType;
import org.overlord.sramp.atom.archive.SrampArchive;
import org.overlord.sramp.atom.archive.SrampArchiveException;
import org.overlord.sramp.common.ArtifactType;
import org.overlord.sramp.shell.commands.archive.AbstractArchiveCommand;
import org.overlord.sramp.shell.i18n.Messages;
import org.overlord.sramp.shell.util.FileEntryPathCompleter;
import org.overlord.sramp.shell.util.FileNameCompleter;

public class AddEntryArchiveCommand
extends AbstractArchiveCommand {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute() throws Exception {
        super.initialize();
        String archivePathArg = this.requiredArgument(0, Messages.i18n.format("InvalidArgMsg.EntryPath", new Object[0]));
        String artifactTypeArg = this.requiredArgument(1, Messages.i18n.format("AddEntry.InvalidArgMsg.ArtifactType", new Object[0]));
        String pathToContent = this.optionalArgument(2);
        if (!this.validate(archivePathArg)) {
            return false;
        }
        FileInputStream contentStream = null;
        try {
            ArtifactType type = ArtifactType.valueOf((String)artifactTypeArg);
            String name = new File(archivePathArg).getName();
            if (pathToContent != null) {
                File contentFile = new File(pathToContent);
                contentStream = FileUtils.openInputStream((File)contentFile);
            }
            BaseArtifactType artifact = type.newArtifactInstance();
            artifact.setName(name);
            this.archive.addEntry(archivePathArg, artifact, (InputStream)contentStream);
            this.print(Messages.i18n.format("AddEntry.Added", new Object[]{archivePathArg}), new Object[0]);
        }
        catch (SrampArchiveException e) {
            try {
                this.print(Messages.i18n.format("AddEntry.SrampArchiveException", new Object[]{e.getLocalizedMessage()}), new Object[0]);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(contentStream);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)contentStream);
        }
        IOUtils.closeQuietly((InputStream)contentStream);
        return true;
    }

    public int tabCompletion(String lastArgument, List<CharSequence> candidates) {
        if (lastArgument == null) {
            lastArgument = "";
        }
        if (this.getArguments().isEmpty()) {
            QName varName = new QName("archive", "active-archive");
            SrampArchive archive = (SrampArchive)this.getContext().getVariable(varName);
            FileEntryPathCompleter delegate = new FileEntryPathCompleter(archive);
            delegate.complete(lastArgument, lastArgument.length(), candidates);
            return 100;
        }
        if (this.getArguments().size() == 2) {
            FileNameCompleter delegate = new FileNameCompleter();
            delegate.complete(lastArgument, lastArgument.length(), candidates);
            return 100;
        }
        return -1;
    }

    @Override
    protected boolean validate(String ... args) {
        if (!this.validateArchiveSession()) {
            return false;
        }
        return this.validateArchivePath(args[0]);
    }
}

