/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.shell.commands.audit;

import java.util.List;
import javax.xml.namespace.QName;
import org.overlord.sramp.client.SrampAtomApiClient;
import org.overlord.sramp.client.audit.AuditEntrySummary;
import org.overlord.sramp.client.audit.AuditResultSet;
import org.overlord.sramp.client.query.ArtifactSummary;
import org.overlord.sramp.client.query.QueryResultSet;
import org.overlord.sramp.shell.BuiltInShellCommand;
import org.overlord.sramp.shell.api.InvalidCommandArgumentException;
import org.overlord.sramp.shell.commands.core.FeedTabCompleter;
import org.overlord.sramp.shell.i18n.Messages;

public class ShowAuditTrailCommand
extends BuiltInShellCommand {
    public boolean execute() throws Exception {
        String artifactIdArg = this.requiredArgument(0, Messages.i18n.format("AuditTrail.InvalidArgMsg.ArtifactId", new Object[0]));
        if (!artifactIdArg.contains(":")) {
            throw new InvalidCommandArgumentException(0, Messages.i18n.format("InvalidArtifactIdFormat", new Object[0]));
        }
        QName clientVarName = new QName("s-ramp", "client");
        QName feedVarName = new QName("s-ramp", "feed");
        SrampAtomApiClient client = (SrampAtomApiClient)this.getContext().getVariable(clientVarName);
        if (client == null) {
            this.print(Messages.i18n.format("MissingSRAMPConnection", new Object[0]), new Object[0]);
            return false;
        }
        String artifactUuid = null;
        String idType = artifactIdArg.substring(0, artifactIdArg.indexOf(58));
        if ("feed".equals(idType)) {
            QueryResultSet rset = (QueryResultSet)this.getContext().getVariable(feedVarName);
            int feedIdx = Integer.parseInt(artifactIdArg.substring(artifactIdArg.indexOf(58) + 1)) - 1;
            if (feedIdx < 0 || (long)feedIdx >= rset.size()) {
                throw new InvalidCommandArgumentException(0, Messages.i18n.format("FeedIndexOutOfRange", new Object[0]));
            }
            ArtifactSummary summary = rset.get(feedIdx);
            artifactUuid = summary.getUuid();
        } else if ("uuid".equals(idType)) {
            artifactUuid = artifactIdArg.substring(artifactIdArg.indexOf(58) + 1);
        } else {
            throw new InvalidCommandArgumentException(0, Messages.i18n.format("InvalidIdFormat", new Object[0]));
        }
        AuditResultSet auditTrail = client.getAuditTrailForArtifact(artifactUuid);
        QName artifactVarName = new QName("audit", "auditTrail");
        this.getContext().setVariable(artifactVarName, (Object)auditTrail);
        this.print(Messages.i18n.format("ShowAuditTrail.EntriesSummary", new Object[]{auditTrail.size()}), new Object[0]);
        this.print("  Idx  " + Messages.i18n.format("AuditEntryLabel", new Object[0]), new Object[0]);
        this.print("  ---  -----------", new Object[0]);
        int idx = 1;
        for (AuditEntrySummary auditEntrySummary : auditTrail) {
            this.print("  %1$3d  %2$s", new Object[]{idx++, auditEntrySummary.toString()});
        }
        return true;
    }

    public int tabCompletion(String lastArgument, List<CharSequence> candidates) {
        int toReturn = FeedTabCompleter.tabCompletion(this.getArguments(), this.getContext(), lastArgument, candidates);
        return toReturn;
    }
}

