/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.shell.commands.archive;

import java.util.List;
import javax.xml.namespace.QName;
import org.overlord.sramp.atom.archive.SrampArchive;
import org.overlord.sramp.shell.commands.archive.AbstractArchiveCommand;
import org.overlord.sramp.shell.i18n.Messages;
import org.overlord.sramp.shell.util.FileEntryPathCompleter;

public class RemoveEntryArchiveCommand
extends AbstractArchiveCommand {
    public boolean execute() throws Exception {
        super.initialize();
        String archivePathArg = this.requiredArgument(0, Messages.i18n.format("InvalidArgMsg.EntryPath", new Object[0]));
        if (!this.validate(archivePathArg)) {
            return false;
        }
        boolean success = this.archive.removeEntry(archivePathArg);
        if (success) {
            this.print(Messages.i18n.format("RemoveEntry.EntryDeleted", new Object[0]), new Object[0]);
        } else {
            this.print(Messages.i18n.format("RemoveEntry.NoEntryFound", new Object[]{archivePathArg}), new Object[0]);
        }
        return true;
    }

    public int tabCompletion(String lastArgument, List<CharSequence> candidates) {
        if (lastArgument == null) {
            lastArgument = "";
        }
        if (this.getArguments().isEmpty()) {
            QName varName = new QName("archive", "active-archive");
            SrampArchive archive = (SrampArchive)this.getContext().getVariable(varName);
            FileEntryPathCompleter delegate = new FileEntryPathCompleter(archive);
            return delegate.complete(lastArgument, lastArgument.length(), candidates);
        }
        return -1;
    }

    @Override
    protected boolean validate(String ... args) {
        if (!this.validateArchiveSession()) {
            return false;
        }
        return this.validateArchivePath(args[0]);
    }
}

