/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.shell.commands.storedquery;

import java.util.List;
import org.overlord.sramp.client.SrampAtomApiClient;
import org.overlord.sramp.shell.BuiltInShellCommand;
import org.overlord.sramp.shell.commands.storedquery.StoredQueryCommandUtil;
import org.overlord.sramp.shell.i18n.Messages;

public class DeleteStoredQueryCommand
extends BuiltInShellCommand {
    public boolean execute() throws Exception {
        String name = this.requiredArgument(0, Messages.i18n.format("StoredQuery.Name.Mandatory", new Object[0]));
        SrampAtomApiClient client = StoredQueryCommandUtil.client(this, this.getContext());
        if (client == null) {
            return false;
        }
        try {
            client.deleteStoredQuery(name);
            this.print(Messages.i18n.format("DeleteStoredQueryCommand.Success", new Object[]{name}), new Object[0]);
        }
        catch (Exception e) {
            this.print(Messages.i18n.format("DeleteStoredQueryCommand.Fail", new Object[]{name}), new Object[0]);
            this.print("\t" + e.getMessage(), new Object[0]);
            return false;
        }
        return true;
    }

    public int tabCompletion(String lastArgument, List<CharSequence> candidates) {
        return StoredQueryCommandUtil.tabCompletion(this, this.getArguments(), this.getContext(), candidates);
    }
}

