/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.shell.commands.storedquery;

import java.util.List;
import org.overlord.sramp.client.SrampAtomApiClient;
import org.overlord.sramp.client.query.ArtifactSummary;
import org.overlord.sramp.client.query.QueryResultSet;
import org.overlord.sramp.common.ArtifactType;
import org.overlord.sramp.shell.BuiltInShellCommand;
import org.overlord.sramp.shell.commands.storedquery.StoredQueryCommandUtil;
import org.overlord.sramp.shell.i18n.Messages;

public class ExecuteStoredQueryCommand
extends BuiltInShellCommand {
    public boolean execute() throws Exception {
        String name = this.requiredArgument(0, Messages.i18n.format("StoredQuery.Name.Mandatory", new Object[0]));
        SrampAtomApiClient client = StoredQueryCommandUtil.client(this, this.getContext());
        if (client == null) {
            return false;
        }
        try {
            this.print(Messages.i18n.format("Query.Querying", new Object[0]), new Object[0]);
            this.print("\t" + name, new Object[0]);
            QueryResultSet rset = client.queryWithStoredQuery(name);
            int entryIndex = 1;
            this.print(Messages.i18n.format("Query.AtomFeedSummary", new Object[]{rset.size()}), new Object[0]);
            this.print("  Idx                    Type Name", new Object[0]);
            this.print("  ---                    ---- ----", new Object[0]);
            for (ArtifactSummary summary : rset) {
                ArtifactType type = summary.getType();
                String displayType = type.getArtifactType().getType().toString();
                if (type.isExtendedType() && type.getExtendedType() != null) {
                    displayType = type.getExtendedType();
                }
                this.print("TEST  %1$3d %2$23s %3$-40s", new Object[]{entryIndex++, displayType, summary.getName()});
            }
            return true;
        }
        catch (Exception e) {
            this.print(Messages.i18n.format("ExecuteStoredQueryCommand.Fail", new Object[0]), new Object[0]);
            this.print("\t" + e.getMessage(), new Object[0]);
            return false;
        }
    }

    public int tabCompletion(String lastArgument, List<CharSequence> candidates) {
        return StoredQueryCommandUtil.tabCompletion(this, this.getArguments(), this.getContext(), candidates);
    }
}

