/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.shell.commands.core;

import java.util.List;
import javax.xml.namespace.QName;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactType;
import org.overlord.sramp.client.SrampAtomApiClient;
import org.overlord.sramp.client.query.ArtifactSummary;
import org.overlord.sramp.client.query.QueryResultSet;
import org.overlord.sramp.common.ArtifactType;
import org.overlord.sramp.shell.BuiltInShellCommand;
import org.overlord.sramp.shell.api.InvalidCommandArgumentException;
import org.overlord.sramp.shell.commands.core.FeedTabCompleter;
import org.overlord.sramp.shell.i18n.Messages;
import org.overlord.sramp.shell.util.FileNameCompleter;

public class DeleteCommand
extends BuiltInShellCommand {
    public boolean execute() throws Exception {
        QName clientVarName = new QName("s-ramp", "client");
        QName artifactVarName = new QName("s-ramp", "artifact");
        QName feedVarName = new QName("s-ramp", "feed");
        SrampAtomApiClient client = (SrampAtomApiClient)this.getContext().getVariable(clientVarName);
        if (client == null) {
            this.print(Messages.i18n.format("MissingSRAMPConnection", new Object[0]), new Object[0]);
            return false;
        }
        BaseArtifactType artifact = null;
        String artifactIdArg = this.optionalArgument(0);
        if (artifactIdArg == null) {
            artifact = (BaseArtifactType)this.getContext().getVariable(artifactVarName);
            if (artifact == null) {
                this.print(Messages.i18n.format("NoActiveArtifact", new Object[0]), new Object[0]);
                return false;
            }
        } else {
            String idType = artifactIdArg.substring(0, artifactIdArg.indexOf(58));
            if ("feed".equals(idType)) {
                QueryResultSet rset = (QueryResultSet)this.getContext().getVariable(feedVarName);
                if (rset == null) {
                    throw new InvalidCommandArgumentException(0, Messages.i18n.format("NoFeed", new Object[0]));
                }
                int feedIdx = Integer.parseInt(artifactIdArg.substring(artifactIdArg.indexOf(58) + 1)) - 1;
                if (feedIdx < 0 || (long)feedIdx >= rset.size()) {
                    throw new InvalidCommandArgumentException(0, Messages.i18n.format("FeedIndexOutOfRange", new Object[0]));
                }
                ArtifactSummary summary = rset.get(feedIdx);
                String artifactUUID = summary.getUuid();
                artifact = client.getArtifactMetaData(summary.getType(), artifactUUID);
            } else if ("uuid".equals(idType)) {
                String artifactUUID = artifactIdArg.substring(artifactIdArg.indexOf(58) + 1);
                artifact = client.getArtifactMetaData(artifactUUID);
            } else {
                throw new InvalidCommandArgumentException(0, Messages.i18n.format("InvalidArtifactIdFormat", new Object[0]));
            }
        }
        try {
            client.deleteArtifact(artifact.getUuid(), ArtifactType.valueOf((BaseArtifactType)artifact));
            this.print(Messages.i18n.format("Delete.Success", new Object[]{artifact.getName()}), new Object[0]);
        }
        catch (Exception e) {
            this.print(Messages.i18n.format("Delete.Failure", new Object[0]), new Object[0]);
            this.print("\t" + e.getMessage(), new Object[0]);
            return false;
        }
        return true;
    }

    public int tabCompletion(String lastArgument, List<CharSequence> candidates) {
        int toReturn = FeedTabCompleter.tabCompletion(this.getArguments(), this.getContext(), lastArgument, candidates);
        if (this.getArguments().size() == 1) {
            if (lastArgument == null) {
                lastArgument = "";
            }
            FileNameCompleter delegate = new FileNameCompleter();
            return delegate.complete(lastArgument, lastArgument.length(), candidates);
        }
        return toReturn;
    }
}

