/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.shell.commands.core;

import java.io.File;
import java.util.List;
import javax.xml.namespace.QName;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactType;
import org.overlord.sramp.atom.archive.SrampArchiveJaxbUtils;
import org.overlord.sramp.client.SrampAtomApiClient;
import org.overlord.sramp.client.query.ArtifactSummary;
import org.overlord.sramp.client.query.QueryResultSet;
import org.overlord.sramp.common.visitors.ArtifactVisitor;
import org.overlord.sramp.common.visitors.ArtifactVisitorHelper;
import org.overlord.sramp.shell.BuiltInShellCommand;
import org.overlord.sramp.shell.api.InvalidCommandArgumentException;
import org.overlord.sramp.shell.commands.core.FeedTabCompleter;
import org.overlord.sramp.shell.i18n.Messages;
import org.overlord.sramp.shell.util.FileNameCompleter;
import org.overlord.sramp.shell.util.PrintArtifactMetaDataVisitor;

public class GetMetaDataCommand
extends BuiltInShellCommand {
    public boolean execute() throws Exception {
        String artifactIdArg = this.requiredArgument(0, Messages.i18n.format("InvalidArgMsg.ArtifactId", new Object[0]));
        String outputFilePathArg = this.optionalArgument(1);
        if (!artifactIdArg.contains(":")) {
            throw new InvalidCommandArgumentException(0, Messages.i18n.format("InvalidArtifactIdFormat", new Object[0]));
        }
        QName clientVarName = new QName("s-ramp", "client");
        QName feedVarName = new QName("s-ramp", "feed");
        SrampAtomApiClient client = (SrampAtomApiClient)this.getContext().getVariable(clientVarName);
        if (client == null) {
            this.print(Messages.i18n.format("MissingSRAMPConnection", new Object[0]), new Object[0]);
            return false;
        }
        BaseArtifactType artifact = null;
        String idType = artifactIdArg.substring(0, artifactIdArg.indexOf(58));
        if ("feed".equals(idType)) {
            QueryResultSet rset = (QueryResultSet)this.getContext().getVariable(feedVarName);
            if (rset == null) {
                throw new InvalidCommandArgumentException(0, Messages.i18n.format("NoFeed", new Object[0]));
            }
            int feedIdx = Integer.parseInt(artifactIdArg.substring(artifactIdArg.indexOf(58) + 1)) - 1;
            if (feedIdx < 0 || (long)feedIdx >= rset.size()) {
                throw new InvalidCommandArgumentException(0, Messages.i18n.format("FeedIndexOutOfRange", new Object[0]));
            }
            ArtifactSummary summary = rset.get(feedIdx);
            String artifactUUID = summary.getUuid();
            artifact = client.getArtifactMetaData(summary.getType(), artifactUUID);
        } else if ("uuid".equals(idType)) {
            String artifactUUID = artifactIdArg.substring(artifactIdArg.indexOf(58) + 1);
            artifact = client.getArtifactMetaData(artifactUUID);
        } else {
            throw new InvalidCommandArgumentException(0, Messages.i18n.format("InvalidArtifactIdFormat", new Object[0]));
        }
        QName artifactVarName = new QName("s-ramp", "artifact");
        this.getContext().setVariable(artifactVarName, (Object)artifact);
        if (outputFilePathArg == null) {
            this.print(Messages.i18n.format("GetMetaData.MetaDataLabel", new Object[]{artifact.getUuid()}), new Object[0]);
            this.print("--------------", new Object[0]);
            PrintArtifactMetaDataVisitor visitor = new PrintArtifactMetaDataVisitor();
            ArtifactVisitorHelper.visitArtifact((ArtifactVisitor)visitor, (BaseArtifactType)artifact);
        } else {
            File outFile = new File(outputFilePathArg);
            if (outFile.isFile()) {
                throw new InvalidCommandArgumentException(1, Messages.i18n.format("GetMetaData.OutputFileExists", new Object[]{outFile.getCanonicalPath()}));
            }
            if (outFile.isDirectory()) {
                String fileName = artifact.getName() + "-metadata.xml";
                outFile = new File(outFile, fileName);
            }
            outFile.getParentFile().mkdirs();
            SrampArchiveJaxbUtils.writeMetaData((File)outFile, (BaseArtifactType)artifact, (boolean)false);
            this.print(Messages.i18n.format("GetMetaData.SavedTo", new Object[]{outFile.getCanonicalPath()}), new Object[0]);
        }
        return true;
    }

    public int tabCompletion(String lastArgument, List<CharSequence> candidates) {
        int toReturn = FeedTabCompleter.tabCompletion(this.getArguments(), this.getContext(), lastArgument, candidates);
        if (this.getArguments().size() == 1) {
            if (lastArgument == null) {
                lastArgument = "";
            }
            FileNameCompleter delegate = new FileNameCompleter();
            return delegate.complete(lastArgument, lastArgument.length(), candidates);
        }
        return toReturn;
    }
}

