/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.shell.commands.maven;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactType;
import org.overlord.sramp.atom.err.SrampAtomException;
import org.overlord.sramp.client.SrampAtomApiClient;
import org.overlord.sramp.client.SrampClientException;
import org.overlord.sramp.client.SrampClientQuery;
import org.overlord.sramp.client.query.ArtifactSummary;
import org.overlord.sramp.client.query.QueryResultSet;
import org.overlord.sramp.common.ArtifactType;
import org.overlord.sramp.common.ArtifactTypeEnum;
import org.overlord.sramp.common.SrampConfig;
import org.overlord.sramp.common.SrampModelUtils;
import org.overlord.sramp.common.visitors.ArtifactVisitor;
import org.overlord.sramp.common.visitors.ArtifactVisitorHelper;
import org.overlord.sramp.shell.BuiltInShellCommand;
import org.overlord.sramp.shell.i18n.Messages;
import org.overlord.sramp.shell.util.FileNameCompleter;
import org.overlord.sramp.shell.util.PrintArtifactMetaDataVisitor;

public class DeployCommand
extends BuiltInShellCommand {
    public static final String SEPARATOR_FULL_NAME = ":";
    private final boolean allowSnapshot = SrampConfig.isSnapshotAllowed();

    public boolean execute() throws Exception {
        String filePathArg = this.requiredArgument(0, Messages.i18n.format("DeployCommand.InvalidArgMsg.LocalFile", new Object[0]));
        String gavArg = this.requiredArgument(1, Messages.i18n.format("DeployCommand.InvalidArgMsg.GAVInfo", new Object[0]));
        String artifactTypeArg = this.optionalArgument(2);
        QName clientVarName = new QName("s-ramp", "client");
        SrampAtomApiClient client = (SrampAtomApiClient)this.getContext().getVariable(clientVarName);
        if (client == null) {
            this.print(Messages.i18n.format("MissingSRAMPConnection", new Object[0]), new Object[0]);
            return false;
        }
        File file = new File(filePathArg);
        if (!file.isFile()) {
            this.print(Messages.i18n.format("DeployCommand.FileNotFound", new Object[]{filePathArg}), new Object[0]);
            return false;
        }
        FileInputStream content = null;
        try {
            ArtifactType artifactType = null;
            if (artifactTypeArg != null && (artifactType = ArtifactType.valueOf((String)artifactTypeArg)).isExtendedType()) {
                artifactType = ArtifactType.ExtendedDocument((String)artifactType.getExtendedType());
            }
            MavenMetaData mmd = new MavenMetaData(gavArg, file);
            if (mmd.type == null) {
                this.print(Messages.i18n.format("DeployCommand.TypeNotSet", new Object[]{file.getName()}), new Object[0]);
                IOUtils.closeQuietly((InputStream)content);
                return false;
            }
            if (!this.allowSnapshot && mmd.snapshot) {
                this.print(Messages.i18n.format("DeployCommand.SnapshotNotAllowed", new Object[]{mmd.getFullName()}), new Object[0]);
                IOUtils.closeQuietly((InputStream)content);
                return false;
            }
            BaseArtifactType artifact = this.findExistingArtifactByGAV(client, mmd);
            if (artifact != null) {
                this.print(Messages.i18n.format("DeployCommand.Failure.ReleaseArtifact.Exist", new Object[]{mmd.getFullName()}), new Object[0]);
                IOUtils.closeQuietly((InputStream)content);
                return false;
            }
            content = FileUtils.openInputStream((File)file);
            artifact = client.uploadArtifact(artifactType, (InputStream)content, file.getName());
            IOUtils.closeQuietly((InputStream)content);
            String artifactName = mmd.artifactId + '-' + mmd.version;
            String pomName = mmd.artifactId + '-' + mmd.version + ".pom";
            SrampModelUtils.setCustomProperty((BaseArtifactType)artifact, (String)"maven.groupId", (String)mmd.groupId);
            SrampModelUtils.setCustomProperty((BaseArtifactType)artifact, (String)"maven.artifactId", (String)mmd.artifactId);
            SrampModelUtils.setCustomProperty((BaseArtifactType)artifact, (String)"maven.version", (String)mmd.version);
            SrampModelUtils.setCustomProperty((BaseArtifactType)artifact, (String)"maven.hash.md5", (String)mmd.md5);
            SrampModelUtils.setCustomProperty((BaseArtifactType)artifact, (String)"maven.hash.sha1", (String)mmd.sha1);
            if (StringUtils.isNotBlank((String)mmd.snapshotId)) {
                SrampModelUtils.setCustomProperty((BaseArtifactType)artifact, (String)"maven.snapshot.id", (String)mmd.snapshotId);
            } else if (mmd.snapshot) {
                SrampModelUtils.setCustomProperty((BaseArtifactType)artifact, (String)"maven.snapshot.id", (String)this.generateSnapshotTimestamp());
            }
            if (mmd.classifier != null) {
                SrampModelUtils.setCustomProperty((BaseArtifactType)artifact, (String)"maven.classifier", (String)mmd.classifier);
                artifactName = artifactName + '-' + mmd.classifier;
            }
            if (mmd.type != null) {
                SrampModelUtils.setCustomProperty((BaseArtifactType)artifact, (String)"maven.type", (String)mmd.type);
                artifactName = artifactName + '.' + mmd.type;
            }
            artifact.setName(artifactName);
            client.updateArtifactMetaData(artifact);
            String pom = this.generatePom(mmd);
            ByteArrayInputStream pomContent = new ByteArrayInputStream(pom.getBytes("UTF-8"));
            BaseArtifactType pomArtifact = ArtifactType.ExtendedDocument((String)"MavenPom").newArtifactInstance();
            pomArtifact.setName(pomName);
            SrampModelUtils.setCustomProperty((BaseArtifactType)pomArtifact, (String)"maven.type", (String)"pom");
            SrampModelUtils.setCustomProperty((BaseArtifactType)pomArtifact, (String)"maven.hash.md5", (String)DigestUtils.md5Hex((String)pom));
            SrampModelUtils.setCustomProperty((BaseArtifactType)pomArtifact, (String)"maven.hash.sha1", (String)DigestUtils.shaHex((String)pom));
            BaseArtifactType returned = client.uploadArtifact(pomArtifact, (InputStream)pomContent);
            QName artifactVarName = new QName("s-ramp", "artifact");
            this.getContext().setVariable(artifactVarName, (Object)artifact);
            this.print(Messages.i18n.format("DeployCommand.Success", new Object[0]), new Object[0]);
            PrintArtifactMetaDataVisitor visitor = new PrintArtifactMetaDataVisitor();
            ArtifactVisitorHelper.visitArtifact((ArtifactVisitor)visitor, (BaseArtifactType)artifact);
        }
        catch (Exception e) {
            this.print(Messages.i18n.format("DeployCommand.Failure", new Object[0]), new Object[0]);
            this.print("\t" + e.getMessage(), new Object[0]);
            IOUtils.closeQuietly((InputStream)content);
            return false;
        }
        return true;
    }

    private String generatePom(MavenMetaData mmd) {
        StringBuilder builder = new StringBuilder();
        builder.append("<project xmlns=\"http://maven.apache.org/POM/4.0.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n");
        builder.append("  xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\">\r\n");
        builder.append("  <modelVersion>4.0.0</modelVersion>\r\n");
        builder.append("  <groupId>" + mmd.groupId + "</groupId>\r\n");
        builder.append("  <artifactId>" + mmd.artifactId + "</artifactId>\r\n");
        builder.append("  <version>" + mmd.version + "</version>\r\n");
        if (mmd.type != null) {
            builder.append("  <packaging>" + mmd.type + "</packaging>\r\n");
        }
        if (mmd.classifier != null) {
            builder.append("  <classifier>" + mmd.classifier + "</classifier>\r\n");
        }
        builder.append("</project>");
        return builder.toString();
    }

    public int tabCompletion(String lastArgument, List<CharSequence> candidates) {
        if (this.getArguments().isEmpty()) {
            if (lastArgument == null) {
                lastArgument = "";
            }
            FileNameCompleter delegate = new FileNameCompleter();
            return delegate.complete(lastArgument, lastArgument.length(), candidates);
        }
        if (this.getArguments().size() == 1) {
            return -1;
        }
        if (this.getArguments().size() == 2) {
            for (ArtifactTypeEnum t : ArtifactTypeEnum.values()) {
                String candidate = t.getType();
                if (lastArgument != null && !candidate.startsWith(lastArgument)) continue;
                candidates.add(candidate);
            }
            return 0;
        }
        return -1;
    }

    private BaseArtifactType findExistingArtifactByGAV(SrampAtomApiClient client, MavenMetaData gavInfo) throws SrampAtomException, SrampClientException, JAXBException {
        Iterator iterator;
        SrampClientQuery clientQuery = null;
        StringBuilder queryBuilder = new StringBuilder();
        queryBuilder.append("/s-ramp");
        ArrayList<String> criteria = new ArrayList<String>();
        ArrayList<String> params = new ArrayList<String>();
        criteria.add("@maven.groupId = ?");
        params.add(gavInfo.groupId);
        criteria.add("@maven.artifactId = ?");
        params.add(gavInfo.artifactId);
        criteria.add("@maven.version = ?");
        params.add(gavInfo.version);
        if (StringUtils.isNotBlank((String)gavInfo.type)) {
            criteria.add("@maven.type = ?");
            params.add(gavInfo.type);
        }
        if (StringUtils.isNotBlank((String)gavInfo.classifier)) {
            criteria.add("@maven.classifier = ?");
            params.add(gavInfo.classifier);
        } else {
            criteria.add("xp2:not(@maven.classifier)");
        }
        if (StringUtils.isNotBlank((String)gavInfo.snapshotId)) {
            return null;
        }
        criteria.add("xp2:not(@maven.snapshot.id)");
        if (criteria.size() > 0) {
            queryBuilder.append("[");
            queryBuilder.append(StringUtils.join(criteria, (String)" and "));
            queryBuilder.append("]");
        }
        clientQuery = client.buildQuery(queryBuilder.toString());
        for (Object e : params) {
            if (e instanceof String) {
                clientQuery.parameter((String)e);
            }
            if (!(e instanceof Calendar)) continue;
            clientQuery.parameter((Calendar)e);
        }
        QueryResultSet rset = clientQuery.count(100).query();
        if (rset.size() > 0L && (iterator = rset.iterator()).hasNext()) {
            ArtifactSummary summary = (ArtifactSummary)iterator.next();
            String uuid = summary.getUuid();
            ArtifactType artifactType = summary.getType();
            BaseArtifactType arty = client.getArtifactMetaData(artifactType, uuid);
            return arty;
        }
        return null;
    }

    private String generateSnapshotTimestamp() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd.hhmmss");
        String timestamp = sdf.format(new Date());
        StringBuilder builder = new StringBuilder();
        builder.append(timestamp).append("-1");
        return builder.toString();
    }

    private static final class MavenMetaData {
        public String groupId;
        public String artifactId;
        public String version;
        public String type;
        public String classifier;
        public String md5;
        public String sha1;
        public boolean snapshot;
        public String snapshotId;

        public MavenMetaData(String gavArg, File file) throws Exception {
            String[] split = gavArg.split(DeployCommand.SEPARATOR_FULL_NAME);
            if (split.length < 3) {
                throw new Exception(Messages.i18n.format("DeployCommand.InvalidArgMsg.GavFormat", new Object[0]));
            }
            this.groupId = split[0];
            this.artifactId = split[1];
            this.version = split[2];
            String filename = file.getName().endsWith(".tmp") ? file.getName().substring(0, file.getName().indexOf(".jar") + 4) : file.getName();
            this.type = split.length >= 4 ? split[3] : this.getType(filename);
            if (split.length >= 5) {
                this.classifier = split[5];
            }
            FileInputStream is = new FileInputStream(file);
            this.md5 = DigestUtils.md5Hex((InputStream)is);
            IOUtils.closeQuietly((InputStream)is);
            is = new FileInputStream(file);
            this.sha1 = DigestUtils.shaHex((InputStream)is);
            IOUtils.closeQuietly((InputStream)is);
            this.snapshot = this.version != null && this.version.endsWith("-SNAPSHOT");
            this.snapshotId = null;
            if (this.snapshot && !filename.contains(this.version)) {
                this.snapshotId = this.extractSnapshotId(filename, this.version, this.type, this.classifier);
            }
        }

        private String extractSnapshotId(String filename, String version, String type, String classifier) {
            if (version == null) {
                return null;
            }
            String front = version.substring(0, version.indexOf("-SNAPSHOT"));
            String back = "." + type;
            if (classifier != null) {
                back = "-" + classifier + back;
            }
            int idx1 = filename.indexOf(front) + front.length() + 1;
            int idx2 = filename.indexOf(back);
            if (idx1 > 0 && idx1 < filename.length() && idx2 > 0 && idx2 < filename.length()) {
                return filename.substring(idx1, idx2);
            }
            return null;
        }

        public String getFullName() {
            StringBuilder builder = new StringBuilder("");
            builder.append(this.groupId).append(DeployCommand.SEPARATOR_FULL_NAME);
            if (StringUtils.isNotBlank((String)this.version)) {
                builder.append(this.version);
            }
            builder.append(DeployCommand.SEPARATOR_FULL_NAME);
            builder.append(this.artifactId);
            builder.append(DeployCommand.SEPARATOR_FULL_NAME);
            builder.append(this.type);
            return builder.toString();
        }

        private String getType(String filename) {
            if (filename.contains(".")) {
                String type = filename.substring(filename.lastIndexOf(46) + 1);
                if (filename.endsWith(".sha1")) {
                    type = filename.substring(0, filename.length() - 5);
                    type = type.substring(type.lastIndexOf(46) + 1) + ".sha1";
                }
                if (filename.endsWith(".md5")) {
                    type = filename.substring(0, filename.length() - 4);
                    type = type.substring(type.lastIndexOf(46) + 1) + ".md5";
                }
                return type;
            }
            return null;
        }
    }
}

