/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.ui.client.places;

import com.google.gwt.http.client.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.overlord.sramp.ui.client.places.AbstractPagedPlace;

public class PlaceUtils {
    private PlaceUtils() {
    }

    public static Map<String, String> parsePlaceToken(String placeToken) {
        if (placeToken == null || placeToken.trim().length() == 0) {
            return Collections.EMPTY_MAP;
        }
        HashMap<String, String> queryParams = new HashMap<String, String>();
        String[] paramSplits = placeToken.split("&");
        if (paramSplits.length > 0) {
            for (String paramSplit : paramSplits) {
                String[] split2 = paramSplit.split("=");
                if (split2.length != 2) continue;
                String key = split2[0];
                String encodedValue = split2[1];
                String value = URL.decodeQueryString((String)encodedValue);
                queryParams.put(key, value);
            }
        }
        return queryParams;
    }

    public static String createPlaceToken(Object ... params) {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (int i = 0; i < params.length; i += 2) {
            String key = (String)params[i];
            Object val = params[i + 1];
            String encodedValue = "";
            if (val == null) continue;
            if (first) {
                first = false;
            } else {
                builder.append("&");
            }
            encodedValue = URL.encodeQueryString((String)val.toString());
            builder.append(key).append("=").append(encodedValue);
        }
        return builder.toString();
    }

    public static String createPlaceToken(AbstractPagedPlace place, Object ... extraParams) {
        Object[] params = new Object[8 + extraParams.length];
        params[0] = "p";
        params[1] = place.getPage();
        params[2] = "ps";
        params[3] = place.getPageSize();
        params[4] = "ob";
        params[5] = place.getOrderBy();
        params[6] = "od";
        params[7] = place.isAscending() == null ? null : (place.isAscending() != false ? "a" : "d");
        for (int idx = 0; idx < extraParams.length; ++idx) {
            params[idx + 8] = extraParams[idx];
        }
        return PlaceUtils.createPlaceToken(params);
    }

    public static void fillPagedPlace(AbstractPagedPlace place, Map<String, String> params) {
        String p = params.get("p");
        String ps = params.get("ps");
        String ob = params.get("ob");
        String od = params.get("od");
        Integer page = null;
        Integer pageSize = null;
        if (p != null) {
            page = new Integer(p);
        }
        if (ps != null) {
            pageSize = new Integer(ps);
        }
        Boolean asc = null;
        if (od != null) {
            asc = "a".equals(od);
        }
        place.setPage(page);
        place.setPageSize(pageSize);
        place.setOrderBy(ob);
        place.setAscending(asc);
    }
}

