/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.ui.client.views;

import com.google.gwt.user.client.ui.DisclosurePanel;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.InlineLabel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import org.overlord.sramp.ui.client.activities.IArtifactActivity;
import org.overlord.sramp.ui.client.places.ArtifactPlace;
import org.overlord.sramp.ui.client.views.AbstractView;
import org.overlord.sramp.ui.client.views.IArtifactView;
import org.overlord.sramp.ui.client.widgets.PleaseWait;
import org.overlord.sramp.ui.client.widgets.SimpleFormLayoutPanel;
import org.overlord.sramp.ui.shared.beans.ArtifactDetails;
import org.overlord.sramp.ui.shared.rsvcs.RemoteServiceException;

public class ArtifactView
extends AbstractView<IArtifactActivity>
implements IArtifactView {
    private ArtifactPlace currentPlace;
    private FlowPanel main = new FlowPanel();

    public ArtifactView() {
        this.main.setStyleName("artifactView");
        this.initWidget((Widget)this.main);
    }

    @Override
    public void onArtifactLoading(ArtifactPlace currentPlace) {
        this.currentPlace = currentPlace;
        this.main.clear();
        this.main.add((Widget)new PleaseWait(this.i18n().translate("views.artifact.loading-message", new Object[0])));
    }

    @Override
    public void onArtifactLoaded(ArtifactDetails artifact) {
        this.main.clear();
        VerticalPanel content = new VerticalPanel();
        content.setStyleName("artifactView-content");
        content.setWidth("100%");
        this.main.add((Widget)content);
        DisclosurePanel details = new DisclosurePanel(this.i18n().translate("views.artifact.details.label", new Object[0]));
        details.setStyleName("dpanel");
        details.setOpen(true);
        details.add(this.createDetailsForm(artifact));
        DisclosurePanel description = new DisclosurePanel(this.i18n().translate("views.artifact.description.label", new Object[0]));
        description.setStyleName("dpanel");
        description.setOpen(true);
        description.add(this.createDescriptionForm(artifact));
        content.add((Widget)details);
        content.add((Widget)description);
        content.setCellWidth((Widget)details, "100%");
        content.setCellWidth((Widget)description, "100%");
    }

    private Widget createDescriptionForm(ArtifactDetails artifact) {
        FlowPanel wrapper = new FlowPanel();
        wrapper.setStyleName("dpanel-content");
        String artifactDesc = artifact.getDescription();
        if (artifactDesc == null || artifactDesc.trim().length() == 0) {
            artifactDesc = this.i18n().translate("views.artifact.no-description.message", new Object[0]);
        }
        Label descriptionWidget = new Label(artifactDesc);
        wrapper.add((Widget)descriptionWidget);
        return wrapper;
    }

    private Widget createDetailsForm(ArtifactDetails artifact) {
        String createdOn = this.i18n().formatDateTime(artifact.getCreatedOn());
        String updatedOn = this.i18n().formatDateTime(artifact.getUpdatedOn());
        FlowPanel wrapper = new FlowPanel();
        wrapper.setStyleName("dpanel-content");
        SimpleFormLayoutPanel formLayoutPanel = new SimpleFormLayoutPanel();
        formLayoutPanel.add(this.i18n().translate("views.artifact.details.uuid-label", new Object[0]), (Widget)new InlineLabel(artifact.getUuid()));
        formLayoutPanel.add(this.i18n().translate("views.artifact.details.name-label", new Object[0]), (Widget)new InlineLabel(artifact.getName()));
        formLayoutPanel.add(this.i18n().translate("views.artifact.details.created-by-label", new Object[0]), (Widget)new InlineLabel(artifact.getCreatedBy()));
        formLayoutPanel.add(this.i18n().translate("views.artifact.details.created-on-label", new Object[0]), (Widget)new InlineLabel(createdOn));
        formLayoutPanel.add(this.i18n().translate("views.artifact.details.updated-by-label", new Object[0]), (Widget)new InlineLabel(artifact.getUpdatedBy()));
        formLayoutPanel.add(this.i18n().translate("views.artifact.details.updated-on-label", new Object[0]), (Widget)new InlineLabel(updatedOn));
        wrapper.add((Widget)formLayoutPanel);
        return wrapper;
    }

    @Override
    public void onArtifactLoadError(RemoteServiceException error) {
        this.main.clear();
        this.main.add((Widget)new Label(this.i18n().translate("views.artifact.load-error.label", this.currentPlace.getUuid())));
        this.growl().growl(this.i18n().translate("views.artifact.load-error.title", new Object[0]), this.i18n().translate("views.artifact.load-error.message", new Object[0]), error);
    }
}

