/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.ui.client.views;

import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.TextColumn;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.SelectionChangeEvent;
import com.google.gwt.view.client.SingleSelectionModel;
import java.util.List;
import org.overlord.sramp.ui.client.activities.IBrowseActivity;
import org.overlord.sramp.ui.client.places.AbstractPagedPlace;
import org.overlord.sramp.ui.client.places.BrowsePlace;
import org.overlord.sramp.ui.client.views.AbstractView;
import org.overlord.sramp.ui.client.views.IBrowseView;
import org.overlord.sramp.ui.client.widgets.ArtifactSummaryPanel;
import org.overlord.sramp.ui.client.widgets.DataTable;
import org.overlord.sramp.ui.client.widgets.DataTableWithPager;
import org.overlord.sramp.ui.client.widgets.PlaceFilterPanel;
import org.overlord.sramp.ui.shared.beans.ArtifactSummary;
import org.overlord.sramp.ui.shared.rsvcs.RemoteServiceException;
import org.overlord.sramp.ui.shared.types.ArtifactFilter;

public class BrowseView
extends AbstractView<IBrowseActivity>
implements IBrowseView {
    private static final int DEFAULT_PAGE_SIZE = 20;
    private static final String DEFAULT_ORDER_BY = "name";
    private ArtifactDataTable artifacts;
    private PlaceFilterPanel<BrowsePlace> filterPanel = new PlaceFilterPanel<BrowsePlace>(this.i18n().translate("views.browse.filter-panel.label", new Object[0])){

        @Override
        protected boolean matches(BrowsePlace currentPlace, BrowsePlace targetPlace) {
            String targetTypeFilter;
            String currentTypeFilter = currentPlace.getTypeFilter();
            if (currentTypeFilter == (targetTypeFilter = targetPlace.getTypeFilter())) {
                return true;
            }
            return currentTypeFilter != null && currentTypeFilter.equals(targetTypeFilter);
        }
    };
    private ArtifactSummaryPanel summaryPanel;
    private BrowsePlace currentPlace;

    public BrowseView() {
        this.artifacts = this.createArtifactTable();
        this.summaryPanel = new ArtifactSummaryPanel();
        HorizontalPanel hpanel = new HorizontalPanel();
        hpanel.setWidth("100%");
        hpanel.add(this.filterPanel);
        hpanel.add((Widget)this.artifacts);
        hpanel.add((Widget)this.summaryPanel);
        hpanel.setCellWidth(this.filterPanel, "175px");
        hpanel.setCellWidth((Widget)this.summaryPanel, "300px");
        this.initWidget((Widget)hpanel);
    }

    private void configureFilters(BrowsePlace currentPlace) {
        for (ArtifactFilter filter : ArtifactFilter.values()) {
            BrowsePlace p = currentPlace.clone();
            p.setPage(null);
            p.setTypeFilter(filter.getCode());
            this.filterPanel.addFilterOption(this.i18n().translate(filter.getI18nKey(), new Object[0]), p);
        }
        this.filterPanel.setCurrentPlace(currentPlace);
    }

    @Override
    public int getDefaultPageSize() {
        return 20;
    }

    @Override
    public String getDefaultOrderBy() {
        return DEFAULT_ORDER_BY;
    }

    private ArtifactDataTable createArtifactTable() {
        ArtifactDataTable table = new ArtifactDataTable();
        table.setWidth("100%");
        table.setEmptyTableMessage(this.i18n().translate("views.browse.artifacts.no-artifacts", new Object[0]));
        table.setLoadingMessage(this.i18n().translate("views.browse.artifacts.loading-artifacts", new Object[0]));
        final SingleSelectionModel selectionModel = new SingleSelectionModel();
        selectionModel.addSelectionChangeHandler(new SelectionChangeEvent.Handler(){

            public void onSelectionChange(SelectionChangeEvent event) {
                ArtifactSummary artifact = (ArtifactSummary)selectionModel.getSelectedObject();
                if (artifact == null) {
                    BrowseView.this.summaryPanel.reset();
                } else {
                    BrowseView.this.summaryPanel.setValue(artifact);
                }
            }
        });
        table.setSelectionModel(selectionModel);
        return table;
    }

    @Override
    public void onQueryStarting(BrowsePlace currentPlace) {
        this.configureFilters(currentPlace);
        this.currentPlace = currentPlace;
        this.artifacts.reset();
    }

    @Override
    public void onQueryComplete(List<ArtifactSummary> artifacts, boolean hasMoreRows) {
        this.artifacts.setRowData(artifacts, this.currentPlace, this.getDefaultPageSize(), hasMoreRows);
    }

    @Override
    public void onQueryFailed(RemoteServiceException error) {
        this.artifacts.setRowData(null, null, -1, false);
        this.growl().growl(this.i18n().translate("views.browse.search-error.title", new Object[0]), this.i18n().translate("views.browse.search-error.message", new Object[0]), error);
    }

    private class ArtifactDataTable
    extends DataTableWithPager<ArtifactSummary> {
        @Override
        protected AbstractPagedPlace createPagerPlace(AbstractPagedPlace currentPlace) {
            BrowsePlace place = new BrowsePlace();
            place.setTypeFilter(((BrowsePlace)currentPlace).getTypeFilter());
            return place;
        }

        @Override
        protected void createColumns(DataTable<ArtifactSummary> table) {
            TextColumn<ArtifactSummary> name = new TextColumn<ArtifactSummary>(){

                public String getValue(ArtifactSummary artifact) {
                    return artifact.getName();
                }
            };
            name.setSortable(true);
            name.setDataStoreName(BrowseView.DEFAULT_ORDER_BY);
            table.addColumn((Column)name, BrowseView.this.i18n().translate("views.browse.table.name-column", new Object[0]));
            TextColumn<ArtifactSummary> createdOn = new TextColumn<ArtifactSummary>(){

                public String getValue(ArtifactSummary artifact) {
                    return BrowseView.this.i18n().formatDateTime(artifact.getCreatedOn());
                }
            };
            createdOn.setSortable(true);
            createdOn.setDataStoreName("createdOn");
            table.addColumn((Column)createdOn, BrowseView.this.i18n().translate("views.browse.table.createdOn-column", new Object[0]));
            TextColumn<ArtifactSummary> createdBy = new TextColumn<ArtifactSummary>(){

                public String getValue(ArtifactSummary artifact) {
                    return artifact.getCreatedBy();
                }
            };
            createdBy.setSortable(true);
            createdBy.setDataStoreName("createdBy");
            table.addColumn((Column)createdBy, BrowseView.this.i18n().translate("views.browse.table.createdBy-column", new Object[0]));
        }

        @Override
        protected String getDefaultOrderBy() {
            return BrowseView.DEFAULT_ORDER_BY;
        }
    }
}

