/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.ui.server;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.jboss.resteasy.plugins.providers.atom.Entry;
import org.overlord.sramp.ArtifactType;
import org.overlord.sramp.client.SrampClientUtils;
import org.overlord.sramp.client.SrampServerException;
import org.overlord.sramp.ui.server.api.SrampAtomApiClient;
import org.overlord.sramp.ui.server.util.ExceptionUtils;
import org.s_ramp.xmlns._2010.s_ramp.BaseArtifactType;

public class ArtifactUploadServlet
extends HttpServlet {
    private static final long serialVersionUID = ArtifactUploadServlet.class.hashCode();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void doPost(HttpServletRequest req, HttpServletResponse response) throws ServletException, IOException {
        HashMap<String, String> responseMap;
        block10: {
            block9: {
                if (!ServletFileUpload.isMultipartContent((HttpServletRequest)req)) break block9;
                DiskFileItemFactory factory = new DiskFileItemFactory();
                ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
                String artifactType = null;
                String fileName = null;
                InputStream artifactContent = null;
                try {
                    List items = upload.parseRequest(req);
                    for (FileItem item : items) {
                        if (item.isFormField()) {
                            if (!item.getFieldName().equals("artifactType")) continue;
                            artifactType = item.getString();
                            continue;
                        }
                        fileName = item.getName();
                        if (fileName != null) {
                            fileName = FilenameUtils.getName((String)fileName);
                        }
                        artifactContent = item.getInputStream();
                    }
                    responseMap = this.uploadArtifact(artifactType, fileName, artifactContent);
                }
                catch (SrampServerException e) {
                    responseMap = new HashMap<String, String>();
                    responseMap.put("exception", "true");
                    responseMap.put("exception-message", e.getMessage());
                    responseMap.put("exception-localStack", ExceptionUtils.getRootStackTrace(e));
                    responseMap.put("exception-remoteStack", e.getRemoteStackTrace());
                    IOUtils.closeQuietly((InputStream)artifactContent);
                }
                catch (Throwable e2) {
                    responseMap = new HashMap();
                    responseMap.put("exception", "true");
                    responseMap.put("exception-message", e2.getMessage());
                    responseMap.put("exception-localStack", ExceptionUtils.getRootStackTrace(e2));
                    {
                        catch (Throwable throwable) {
                            IOUtils.closeQuietly(artifactContent);
                            throw throwable;
                        }
                    }
                    IOUtils.closeQuietly((InputStream)artifactContent);
                }
                IOUtils.closeQuietly(artifactContent);
                break block10;
            }
            response.sendError(415, "Request contents type is not supported by the servlet.");
            return;
        }
        this.writeToResponse(responseMap, response);
    }

    private Map<String, String> uploadArtifact(String artifactType, String fileName, InputStream artifactContent) throws Exception {
        SrampAtomApiClient client = SrampAtomApiClient.getInstance();
        ArtifactType at = ArtifactType.valueOf((String)artifactType);
        Entry entry = client.uploadArtifact(at, artifactContent, fileName);
        BaseArtifactType artifact = SrampClientUtils.unwrapSrampArtifact((ArtifactType)at, (Entry)entry);
        HashMap<String, String> responseParams = new HashMap<String, String>();
        responseParams.put("model", at.getModel());
        responseParams.put("type", at.name());
        responseParams.put("uuid", artifact.getUuid());
        return responseParams;
    }

    private void writeToResponse(Map<String, String> responseMap, HttpServletResponse response) throws IOException {
        response.setContentType("application/json; charset=UTF8");
        StringBuilder builder = new StringBuilder();
        builder.append("({");
        boolean first = true;
        for (Map.Entry<String, String> entry : responseMap.entrySet()) {
            String key = entry.getKey();
            String val = entry.getValue();
            if (first) {
                first = false;
            } else {
                builder.append(",");
            }
            builder.append("\"");
            builder.append(key);
            builder.append("\" : \"");
            if (val != null) {
                val = val.replace("\"", "\\\"");
                val = val.replace("\n", "\\n");
                builder.append(val);
            }
            builder.append("\"");
        }
        builder.append("})");
        byte[] jsonData = builder.toString().getBytes("UTF-8");
        response.setContentLength(jsonData.length);
        response.getOutputStream().write(jsonData);
        response.getOutputStream().flush();
    }
}

