/*
 * Copyright 2012 JBoss Inc
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.overlord.sramp.ui.client;

import org.overlord.sramp.ui.client.views.IArtifactView;
import org.overlord.sramp.ui.client.views.IBrowseView;
import org.overlord.sramp.ui.client.views.IDashboardView;

import com.google.gwt.place.shared.PlaceController;
import com.google.web.bindery.event.shared.EventBus;

/**
 * Client factory interface.
 *
 * @author eric.wittmann@redhat.com
 */
public interface IClientFactory {
	
	/*
	 * Event Bus
	 */
	public EventBus getEventBus();
	
	/*
	 * Place controller
	 */
	public PlaceController getPlaceController();
	
	/*
	 * Views
	 */
	public IDashboardView createDashboardView();
	public IBrowseView createBrowseView();
	public IArtifactView createArtifactView();
	
}
