/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.ui.client.activities;

import com.google.gwt.event.shared.EventBus;
import com.google.gwt.place.shared.Place;
import com.google.gwt.user.client.ui.AcceptsOneWidget;
import com.google.gwt.user.client.ui.IsWidget;
import org.overlord.sramp.ui.client.IClientFactory;
import org.overlord.sramp.ui.client.activities.IActivity;
import org.overlord.sramp.ui.client.services.IService;
import org.overlord.sramp.ui.client.services.ServiceNotFoundException;
import org.overlord.sramp.ui.client.services.Services;
import org.overlord.sramp.ui.client.services.breadcrumb.IBreadcrumbService;
import org.overlord.sramp.ui.client.services.i18n.ILocalizationService;
import org.overlord.sramp.ui.client.views.IView;
import org.overlord.sramp.ui.client.widgets.BreadcrumbPanel;

public abstract class AbstractActivity<P extends Place, V extends IView<?>>
extends com.google.gwt.activity.shared.AbstractActivity
implements IActivity {
    private P place;
    private V view;
    private IClientFactory clientFactory;

    public AbstractActivity(P place, IClientFactory clientFactory) {
        this.setPlace(place);
        this.setClientFactory(clientFactory);
    }

    @Override
    public void goTo(Place place) {
        this.getClientFactory().getPlaceController().goTo(place);
    }

    public P getPlace() {
        return this.place;
    }

    public void setPlace(P place) {
        this.place = place;
    }

    public V getView() {
        return this.view;
    }

    public void setView(V view) {
        this.view = view;
    }

    public IClientFactory getClientFactory() {
        return this.clientFactory;
    }

    public void setClientFactory(IClientFactory clientFactory) {
        this.clientFactory = clientFactory;
    }

    public final void start(AcceptsOneWidget panel, EventBus eventBus) {
        V view = this.createView(eventBus);
        this.setView(view);
        panel.setWidget((IsWidget)view.asWidget());
        this.doStart(panel, eventBus);
        BreadcrumbPanel breadcrumbPanel = this.getService(IBreadcrumbService.class).getBreadcrumbPanel();
        breadcrumbPanel.clear();
        this.updateBreadcrumb(breadcrumbPanel);
    }

    protected abstract void updateBreadcrumb(BreadcrumbPanel var1);

    protected abstract V createView(EventBus var1);

    protected void doStart(AcceptsOneWidget panel, EventBus eventBus) {
    }

    protected <T extends IService> T getService(Class<T> serviceType) throws ServiceNotFoundException {
        return Services.getServices().getService(serviceType);
    }

    protected ILocalizationService i18n() {
        return this.getService(ILocalizationService.class);
    }
}

