/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.ui.client.views;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.FormPanel;
import com.google.gwt.user.client.ui.HTMLPanel;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.InlineLabel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import org.overlord.sramp.ui.client.activities.IDashboardActivity;
import org.overlord.sramp.ui.client.places.ArtifactPlace;
import org.overlord.sramp.ui.client.places.BrowsePlace;
import org.overlord.sramp.ui.client.services.growl.GrowlType;
import org.overlord.sramp.ui.client.util.JsonMap;
import org.overlord.sramp.ui.client.views.AbstractView;
import org.overlord.sramp.ui.client.views.IDashboardView;
import org.overlord.sramp.ui.client.widgets.ArtifactUploadForm;
import org.overlord.sramp.ui.client.widgets.PlaceHyperlink;
import org.overlord.sramp.ui.client.widgets.TitlePanel;
import org.overlord.sramp.ui.client.widgets.UnorderedListPanel;
import org.overlord.sramp.ui.shared.rsvcs.RemoteServiceException;

public class DashboardView
extends AbstractView<IDashboardActivity>
implements IDashboardView {
    public DashboardView() {
        HorizontalPanel dashboardPanel = new HorizontalPanel();
        dashboardPanel.getElement().setId("dashboard");
        dashboardPanel.getElement().setAttribute("style", "width: 100%");
        VerticalPanel leftColumn = new VerticalPanel();
        leftColumn.getElement().setClassName("dashColumn");
        leftColumn.getElement().addClassName("left");
        VerticalPanel rightColumn = new VerticalPanel();
        rightColumn.getElement().setClassName("dashColumn");
        rightColumn.getElement().addClassName("right");
        dashboardPanel.add((Widget)leftColumn);
        dashboardPanel.add((Widget)rightColumn);
        TitlePanel activitiesPanel = new TitlePanel(this.i18n().translate("views.dashboard.activities-panel.title", new Object[0]));
        activitiesPanel.getElement().setId("dash-activitiesPanel");
        UnorderedListPanel ulPanel = new UnorderedListPanel();
        List<Widget> activityLinks = this.createActivityLinks();
        for (Widget link : activityLinks) {
            ulPanel.add(link);
        }
        activitiesPanel.setWidget((Widget)ulPanel);
        TitlePanel uploadPanel = new TitlePanel(this.i18n().translate("views.dashboard.upload-panel.title", new Object[0]));
        uploadPanel.getElement().setId("dash-uploadPanel");
        uploadPanel.setWidget(this.createUploadForm());
        TitlePanel helpPanel = new TitlePanel(this.i18n().translate("views.dashboard.help-panel.title", new Object[0]));
        helpPanel.getElement().setId("dash-helpPanel");
        HTMLPanel helpText = new HTMLPanel(this.i18n().translate("views.dashboard.help-panel.help-text", new Object[0]));
        helpPanel.setWidget((Widget)helpText);
        dashboardPanel.setCellWidth((Widget)leftColumn, "50%");
        dashboardPanel.setCellWidth((Widget)rightColumn, "50%");
        leftColumn.add((Widget)activitiesPanel);
        leftColumn.add((Widget)uploadPanel);
        rightColumn.add((Widget)helpPanel);
        this.initWidget((Widget)dashboardPanel);
    }

    private Widget createUploadForm() {
        String url = GWT.getModuleBaseURL() + "services/artifactUpload";
        final ArtifactUploadForm form = new ArtifactUploadForm(url);
        final int[] growlId = new int[1];
        form.addSubmitHandler(new FormPanel.SubmitHandler(){

            public void onSubmit(FormPanel.SubmitEvent event) {
                int id;
                growlId[0] = id = DashboardView.this.growl().growl(DashboardView.this.i18n().translate("views.dashboard.upload-dialog.title-1", new Object[0]), DashboardView.this.i18n().translate("views.dashboard.upload-dialog.please-wait", form.getFilename()), GrowlType.progress);
            }
        });
        form.addSubmitCompleteHandler(new FormPanel.SubmitCompleteHandler(){

            public void onSubmitComplete(FormPanel.SubmitCompleteEvent event) {
                String jsonData = event.getResults();
                int startIdx = jsonData.indexOf(40);
                int endIdx = jsonData.lastIndexOf(41) + 1;
                JsonMap jsonMap = JsonMap.fromJSON(jsonData = jsonData.endsWith(")") ? jsonData.substring(startIdx) : jsonData.substring(startIdx, endIdx));
                boolean isError = "true".equals(jsonMap.get("exception"));
                if (isError) {
                    String errorMessage = jsonMap.get("exception-message");
                    String errorLocalStack = jsonMap.get("exception-localStack");
                    String errorRemoteStack = jsonMap.get("exception-remoteStack");
                    RemoteServiceException error = new RemoteServiceException(errorMessage);
                    error.setRootStackTrace(errorLocalStack + "\nCaused By:\n" + errorRemoteStack);
                    DashboardView.this.growl().onProgressError(growlId[0], DashboardView.this.i18n().translate("views.dashboard.upload-dialog.error.title", new Object[0]), error);
                } else {
                    String uuid = jsonMap.get("uuid");
                    String model = jsonMap.get("model");
                    String type = jsonMap.get("type");
                    DashboardView.this.growl().onProgressComplete(growlId[0], DashboardView.this.i18n().translate("views.dashboard.upload-dialog.title-2", new Object[0]), DashboardView.this.createUploadSuccessWidget(model, type, uuid, form.getFilename()));
                }
                form.reset();
            }
        });
        return form;
    }

    protected Widget createUploadSuccessWidget(String model, String type, String uuid, String artifactName) {
        FlowPanel wrapper = new FlowPanel();
        wrapper.add((Widget)new InlineLabel(this.i18n().translate("views.dashboard.upload-dialog.success.message", uuid, artifactName)));
        wrapper.add((Widget)new InlineLabel(" "));
        ArtifactPlace artifactPlace = new ArtifactPlace(model, type, uuid);
        PlaceHyperlink link = new PlaceHyperlink(this.i18n().translate("views.dashboard.upload-dialog.success.link-label", new Object[0]), artifactPlace);
        wrapper.add((Widget)link);
        return wrapper;
    }

    private List<Widget> createActivityLinks() {
        ArrayList<Widget> links = new ArrayList<Widget>();
        PlaceHyperlink browseLink = new PlaceHyperlink(this.i18n().translate("views.dashboard.activities-panel.activities.browse.label", new Object[0]), new BrowsePlace());
        links.add((Widget)browseLink);
        PlaceHyperlink ontologyLink = new PlaceHyperlink(this.i18n().translate("views.dashboard.activities-panel.activities.ontologies.label", new Object[0]), null);
        links.add((Widget)ontologyLink);
        PlaceHyperlink savedQueriesLink = new PlaceHyperlink(this.i18n().translate("views.dashboard.activities-panel.activities.saved-queries.label", new Object[0]), null);
        links.add((Widget)savedQueriesLink);
        return links;
    }
}

