/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.ui.client.widgets;

import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.FileUpload;
import com.google.gwt.user.client.ui.FormPanel;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import org.overlord.sramp.ui.client.services.Services;
import org.overlord.sramp.ui.client.services.i18n.ILocalizationService;

public class ArtifactUploadForm
extends FormPanel {
    final FileUpload upload = new FileUpload();

    public ArtifactUploadForm(String url) {
        ILocalizationService i18n = Services.getServices().getService(ILocalizationService.class);
        this.setAction(url);
        this.setEncoding("multipart/form-data");
        this.setMethod("post");
        VerticalPanel vpanel = new VerticalPanel();
        final ListBox artifactType = new ListBox();
        final Button submitButton = new Button(i18n.translate("widgets.artifact-upload.submit", new Object[0]));
        artifactType.setName("artifactType");
        artifactType.addItem(i18n.translate("widgets.artifact-upload.please-choose", new Object[0]), "");
        artifactType.addItem(i18n.translate("widgets.artifact-upload.choice.doc", new Object[0]), "Document");
        artifactType.addItem(i18n.translate("widgets.artifact-upload.choice.xml", new Object[0]), "XmlDocument");
        artifactType.addItem(i18n.translate("widgets.artifact-upload.choice.xsd", new Object[0]), "XsdDocument");
        artifactType.addItem(i18n.translate("widgets.artifact-upload.choice.wsdl", new Object[0]), "WsdlDocument");
        artifactType.addItem(i18n.translate("widgets.artifact-upload.choice.policy", new Object[0]), "PolicyDocument");
        artifactType.setSelectedIndex(0);
        this.upload.getElement().setClassName("file");
        this.upload.setName("artifact");
        submitButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                ArtifactUploadForm.this.submit();
            }
        });
        submitButton.setEnabled(false);
        vpanel.add((Widget)this.upload);
        vpanel.add((Widget)artifactType);
        vpanel.add((Widget)submitButton);
        ChangeHandler changeHandler = new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                boolean validSelection = !"".equals(artifactType.getValue(artifactType.getSelectedIndex()));
                boolean validFile = ArtifactUploadForm.this.upload.getFilename() != null && ArtifactUploadForm.this.upload.getFilename().trim().length() > 0;
                submitButton.setEnabled(validSelection && validFile);
            }
        };
        this.upload.addChangeHandler(changeHandler);
        this.upload.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                String filename = ArtifactUploadForm.this.upload.getFilename().toLowerCase();
                if (filename.endsWith(".xml")) {
                    artifactType.setSelectedIndex(2);
                } else if (filename.endsWith(".xsd")) {
                    artifactType.setSelectedIndex(3);
                } else if (filename.endsWith(".wsdl")) {
                    artifactType.setSelectedIndex(4);
                } else if (filename.endsWith(".wspolicy")) {
                    artifactType.setSelectedIndex(5);
                } else {
                    artifactType.setSelectedIndex(1);
                }
                submitButton.setEnabled(true);
            }
        });
        artifactType.addChangeHandler(changeHandler);
        this.setWidget((Widget)vpanel);
    }

    public String getFilename() {
        return this.upload.getFilename();
    }
}

