/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.ui.client.widgets;

import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.ColumnSortEvent;
import com.google.gwt.user.cellview.client.ColumnSortList;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.InlineLabel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.ProvidesKey;
import com.google.gwt.view.client.SelectionModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.overlord.sramp.ui.client.places.AbstractPagedPlace;
import org.overlord.sramp.ui.client.services.Services;
import org.overlord.sramp.ui.client.services.i18n.ILocalizationService;
import org.overlord.sramp.ui.client.services.place.IPlaceService;
import org.overlord.sramp.ui.client.widgets.DataTable;
import org.overlord.sramp.ui.client.widgets.PlacePager;
import org.overlord.sramp.ui.client.widgets.PleaseWait;

public abstract class DataTableWithPager<T>
extends FlowPanel {
    private DataTable<T> table = new DataTable<T>(this.createKeyProvider());
    private PlacePager pager = new PlacePager();
    private AbstractPagedPlace currentPlace = null;

    public DataTableWithPager() {
        this.createColumns(this.table);
        this.configureTable(this.table);
        this.getElement().setClassName("dataTableWrapper");
        this.add((Widget)this.table);
        this.add((Widget)this.pager);
    }

    protected void configureTable(DataTable<T> table) {
        table.getElement().setClassName("dataTable");
        table.setWidth("100%");
        table.addColumnSortHandler(new ColumnSortEvent.Handler(){

            public void onColumnSort(ColumnSortEvent event) {
                ColumnSortList columnSortList = event.getColumnSortList();
                ColumnSortList.ColumnSortInfo sortInfo = columnSortList.get(0);
                DataTableWithPager.this.onSort(sortInfo.getColumn().getDataStoreName(), sortInfo.isAscending());
            }
        });
    }

    protected void onSort(String dataStoreName, boolean ascending) {
        AbstractPagedPlace place = this.createPagerPlace(this.currentPlace);
        place.setPage(this.currentPlace.getPage());
        place.setPageSize(this.currentPlace.getPageSize());
        place.setOrderBy(dataStoreName);
        place.setAscending(ascending);
        Services.getServices().getService(IPlaceService.class).goTo(place);
    }

    protected ProvidesKey<T> createKeyProvider() {
        return new ProvidesKey<T>(){

            public Object getKey(T item) {
                return item;
            }
        };
    }

    protected abstract void createColumns(DataTable<T> var1);

    public void setLoadingMessage(String message) {
        this.table.setLoadingIndicator((Widget)new PleaseWait(message));
    }

    public void setEmptyTableMessage(String message) {
        this.table.setEmptyTableWidget((Widget)new InlineLabel(message));
    }

    public void setSelectionModel(SelectionModel<T> selectionModel) {
        this.table.setSelectionModel(selectionModel);
    }

    public SelectionModel<T> getSelectionModel() {
        return this.table.getSelectionModel();
    }

    public void reset() {
        this.table.reset();
        this.pager.setVisible(false);
    }

    public void setRowData(List<T> rowData, AbstractPagedPlace currentPlace, int defaultPageSize, boolean hasMoreRows) {
        if (rowData == null) {
            this.table.setRowData(Collections.EMPTY_LIST);
            return;
        }
        AbstractPagedPlace prevPlace = null;
        AbstractPagedPlace nextPlace = null;
        if (currentPlace.getPage(0) > 0) {
            prevPlace = this.createPagerPlace(currentPlace);
            prevPlace.setPage(currentPlace.getPage(0) - 1);
            prevPlace.setPageSize(currentPlace.getPageSize());
            prevPlace.setOrderBy(currentPlace.getOrderBy());
            prevPlace.setAscending(currentPlace.isAscending());
        }
        if (hasMoreRows) {
            nextPlace = this.createPagerPlace(currentPlace);
            nextPlace.setPage(currentPlace.getPage(0) + 1);
            nextPlace.setPageSize(currentPlace.getPageSize());
            nextPlace.setOrderBy(currentPlace.getOrderBy());
            nextPlace.setAscending(currentPlace.isAscending());
        }
        int start = currentPlace.getPage(0) * currentPlace.getPageSize(defaultPageSize) + 1;
        int end = start + rowData.size() - 1;
        ILocalizationService i18n = Services.getServices().getService(ILocalizationService.class);
        String pagerMsg = i18n.translate("widgets.dataTable.pager.label", currentPlace.getPage(0) + 1, start, end);
        this.updateColumnSort(currentPlace);
        this.currentPlace = currentPlace;
        this.pager.init(prevPlace, nextPlace, pagerMsg);
        this.pager.setVisible(rowData.size() > 0 || currentPlace.getPage(0) > 0);
        this.table.setRowData(rowData);
    }

    private void updateColumnSort(AbstractPagedPlace currentPlace) {
        String orderBy = currentPlace.getOrderBy();
        Boolean asc = currentPlace.isAscending();
        if (orderBy == null) {
            orderBy = this.getDefaultOrderBy();
        }
        if (orderBy == null) {
            return;
        }
        if (asc == null) {
            asc = true;
        }
        for (int idx = 0; idx < this.table.getColumnCount(); ++idx) {
            Column column = this.table.getColumn(idx);
            if (!column.isSortable() || !orderBy.equals(column.getDataStoreName())) continue;
            ColumnSortList.ColumnSortInfo sortInfo = new ColumnSortList.ColumnSortInfo(column, asc.booleanValue());
            this.table.getColumnSortList().push(sortInfo);
        }
    }

    protected abstract String getDefaultOrderBy();

    protected abstract AbstractPagedPlace createPagerPlace(AbstractPagedPlace var1);

    public List<T> getCurrentSelection() {
        ArrayList rval = new ArrayList();
        this.table.getSelectionModel();
        return rval;
    }
}

