/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.ui.client.widgets;

import com.google.gwt.place.shared.Place;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.impl.HyperlinkImpl;
import org.overlord.sramp.ui.client.services.Services;
import org.overlord.sramp.ui.client.services.place.IPlaceService;

public class PlaceHyperlink
extends Anchor {
    private static HyperlinkImpl impl = new HyperlinkImpl();
    private Place targetPlace;
    private boolean enabled = true;

    public PlaceHyperlink(String text) {
        this(text, null);
    }

    public PlaceHyperlink(String text, Place place) {
        super(text);
        this.targetPlace = place;
        this.getElement().setClassName("placeLink");
        this.setTargetPlace(place);
    }

    public Place getTargetPlace() {
        return this.targetPlace;
    }

    public void setTargetPlace(Place place) {
        this.setHref("#" + PlaceHyperlink.toHistoryToken(place));
        this.targetPlace = place;
        this.setEnabled(place != null);
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (enabled) {
            this.getElement().removeClassName("disabled");
        } else {
            this.getElement().addClassName("disabled");
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void onBrowserEvent(Event event) {
        if (!this.isEnabled()) {
            DOM.eventPreventDefault((Event)event);
        } else {
            super.onBrowserEvent(event);
            if (DOM.eventGetType((Event)event) == 1 && impl.handleAsClick(event)) {
                History.newItem((String)PlaceHyperlink.toHistoryToken(this.getTargetPlace()));
                DOM.eventPreventDefault((Event)event);
            }
        }
    }

    private static String toHistoryToken(Place place) {
        if (place == null) {
            return "";
        }
        IPlaceService placeService = Services.getServices().getService(IPlaceService.class);
        return placeService.generatePlaceToken(place);
    }
}

