/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.ui.server.rsvcs;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import java.util.ArrayList;
import java.util.List;
import org.jboss.resteasy.plugins.providers.atom.Entry;
import org.jboss.resteasy.plugins.providers.atom.Feed;
import org.jboss.resteasy.plugins.providers.atom.Person;
import org.overlord.sramp.ArtifactType;
import org.overlord.sramp.atom.SrampAtomUtils;
import org.overlord.sramp.client.SrampServerException;
import org.overlord.sramp.ui.server.api.SrampAtomApiClient;
import org.overlord.sramp.ui.server.util.ExceptionUtils;
import org.overlord.sramp.ui.shared.beans.ArtifactSummary;
import org.overlord.sramp.ui.shared.beans.PageInfo;
import org.overlord.sramp.ui.shared.rsvcs.IQueryRemoteService;
import org.overlord.sramp.ui.shared.rsvcs.RemoteServiceException;
import org.overlord.sramp.ui.shared.types.ArtifactFilter;

public class QueryRemoteService
extends RemoteServiceServlet
implements IQueryRemoteService {
    private static final long serialVersionUID = QueryRemoteService.class.hashCode();

    public List<ArtifactSummary> findArtifacts(PageInfo page, ArtifactFilter filter) throws RemoteServiceException {
        try {
            Feed feed = SrampAtomApiClient.getInstance().query(filter.getQueryBase(), page.getPage(), page.getPageSize(), page.getOrderBy(), page.isAscending());
            ArrayList<ArtifactSummary> rval = new ArrayList<ArtifactSummary>();
            for (Entry entry : feed.getEntries()) {
                String author = null;
                if (entry.getAuthors() != null && entry.getAuthors().size() > 0) {
                    author = ((Person)entry.getAuthors().get(0)).getName();
                }
                ArtifactSummary arty = new ArtifactSummary();
                ArtifactType artifactType = SrampAtomUtils.getArtifactType((Entry)entry);
                arty.setModel(artifactType.getArtifactType().getModel());
                arty.setType(artifactType.getArtifactType().getType());
                arty.setUuid(entry.getId().toString());
                arty.setName(entry.getTitle());
                arty.setDescription(entry.getSummary());
                arty.setCreatedBy(author);
                arty.setCreatedOn(entry.getPublished());
                arty.setUpdatedOn(entry.getUpdated());
                rval.add(arty);
            }
            return rval;
        }
        catch (SrampServerException e) {
            throw ExceptionUtils.createRemoteException((SrampServerException)e);
        }
        catch (Throwable t) {
            throw ExceptionUtils.createRemoteException((Throwable)t);
        }
    }
}

