/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.ui.server.visitors;

import java.util.Collection;
import org.overlord.sramp.common.visitors.HierarchicalArtifactVisitorAdapter;
import org.overlord.sramp.ui.shared.beans.ArtifactDetails;
import org.overlord.sramp.ui.shared.beans.RelationshipDetails;
import org.s_ramp.xmlns._2010.s_ramp.BaseArtifactType;
import org.s_ramp.xmlns._2010.s_ramp.Binding;
import org.s_ramp.xmlns._2010.s_ramp.BindingOperation;
import org.s_ramp.xmlns._2010.s_ramp.DerivedArtifactType;
import org.s_ramp.xmlns._2010.s_ramp.DocumentArtifactTarget;
import org.s_ramp.xmlns._2010.s_ramp.Fault;
import org.s_ramp.xmlns._2010.s_ramp.Message;
import org.s_ramp.xmlns._2010.s_ramp.Operation;
import org.s_ramp.xmlns._2010.s_ramp.OperationInput;
import org.s_ramp.xmlns._2010.s_ramp.OperationOutput;
import org.s_ramp.xmlns._2010.s_ramp.Part;
import org.s_ramp.xmlns._2010.s_ramp.Port;
import org.s_ramp.xmlns._2010.s_ramp.PortType;
import org.s_ramp.xmlns._2010.s_ramp.Relationship;
import org.s_ramp.xmlns._2010.s_ramp.Target;
import org.s_ramp.xmlns._2010.s_ramp.WsdlDocument;
import org.s_ramp.xmlns._2010.s_ramp.WsdlService;

public class RelationshipVisitor
extends HierarchicalArtifactVisitorAdapter {
    private ArtifactDetails details;

    public RelationshipVisitor(ArtifactDetails details) {
        this.details = details;
    }

    protected void visitBase(BaseArtifactType artifact) {
        for (Relationship rel : artifact.getRelationship()) {
            String relationshipType = rel.getRelationshipType();
            for (Target target : rel.getRelationshipTarget()) {
                this.addRelationship(relationshipType, target);
            }
        }
    }

    protected void visitDerived(DerivedArtifactType artifact) {
        DocumentArtifactTarget relatedDocument = artifact.getRelatedDocument();
        this.addRelationship("relatedDocument", (Target)relatedDocument);
    }

    public void visit(WsdlDocument artifact) {
        super.visit(artifact);
        this.addRelationships("importedXsds", (Collection)artifact.getImportedXsds());
        this.addRelationships("includedXsds", (Collection)artifact.getIncludedXsds());
        this.addRelationships("importedWsdls", (Collection)artifact.getImportedWsdls());
    }

    public void visit(Message artifact) {
        super.visit(artifact);
        this.addRelationships("part", (Collection)artifact.getPart());
    }

    public void visit(Part artifact) {
        super.visit(artifact);
        this.addRelationship("element", (Target)artifact.getElement());
        this.addRelationship("type", (Target)artifact.getType());
    }

    public void visit(PortType artifact) {
        super.visit(artifact);
        this.addRelationships("operation", (Collection)artifact.getOperation());
    }

    public void visit(Operation artifact) {
        super.visit(artifact);
        this.addRelationship("input", (Target)artifact.getInput());
        this.addRelationship("output", (Target)artifact.getOutput());
        this.addRelationships("fault", (Collection)artifact.getFault());
    }

    public void visit(OperationInput artifact) {
        super.visit(artifact);
        this.addRelationship("message", (Target)artifact.getMessage());
    }

    public void visit(OperationOutput artifact) {
        super.visit(artifact);
        this.addRelationship("message", (Target)artifact.getMessage());
    }

    public void visit(Fault artifact) {
        super.visit(artifact);
        this.addRelationship("message", (Target)artifact.getMessage());
    }

    public void visit(Binding artifact) {
        super.visit(artifact);
        this.addRelationships("bindingOperation", (Collection)artifact.getBindingOperation());
        this.addRelationship("portType", (Target)artifact.getPortType());
    }

    public void visit(BindingOperation artifact) {
        super.visit(artifact);
        this.addRelationship("input", (Target)artifact.getInput());
        this.addRelationship("output", (Target)artifact.getOutput());
        this.addRelationships("fault", (Collection)artifact.getFault());
        this.addRelationship("operation", (Target)artifact.getOperation());
    }

    public void visit(WsdlService artifact) {
        super.visit(artifact);
        this.addRelationships("port", (Collection)artifact.getPort());
    }

    public void visit(Port artifact) {
        super.visit(artifact);
        this.addRelationship("binding", (Target)artifact.getBinding());
    }

    protected void addRelationship(String relationshipType, Target target) {
        if (target != null) {
            RelationshipDetails rd = new RelationshipDetails(relationshipType);
            rd.setTargetUuid(target.getValue());
            rd.setHref(target.getHref());
            this.details.addRelationship(rd);
        }
    }

    protected void addRelationships(String relationshipName, Collection<? extends Target> targets) {
        for (Target target : targets) {
            this.addRelationship(relationshipName, target);
        }
    }
}

