/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.ui.client;

import com.google.gwt.place.shared.Place;
import com.google.gwt.place.shared.PlaceHistoryMapper;
import com.google.gwt.place.shared.PlaceTokenizer;
import java.util.HashMap;
import java.util.Map;
import org.overlord.sramp.ui.client.places.PlaceList;

public class PlaceHistoryMapperImpl
implements PlaceHistoryMapper {
    private Map<String, PlaceTokenizer<Place>> tokenizersByPrefix = new HashMap<String, PlaceTokenizer<Place>>();
    private Map<Class<?>, PlaceTokenizer<Place>> tokenizersByPlace = new HashMap();
    private Map<Class<?>, String> prefixesByPlace = new HashMap();

    public PlaceHistoryMapperImpl() {
        for (Object[] placeSpec : PlaceList.PLACES) {
            String prefix = (String)placeSpec[0];
            PlaceTokenizer tokenizer = (PlaceTokenizer)placeSpec[1];
            Class placeClass = (Class)placeSpec[2];
            this.tokenizersByPrefix.put(prefix, (PlaceTokenizer<Place>)tokenizer);
            this.tokenizersByPlace.put(placeClass, (PlaceTokenizer<Place>)tokenizer);
            this.prefixesByPlace.put(placeClass, prefix);
        }
    }

    public Place getPlace(String token) {
        String rest;
        String prefix;
        int separatorAt = token.indexOf(63);
        if (separatorAt >= 0) {
            prefix = token.substring(0, separatorAt);
            rest = token.substring(separatorAt + 1);
        } else {
            prefix = token;
            rest = null;
        }
        PlaceTokenizer<Place> tokenizer = this.tokenizersByPrefix.get(prefix);
        if (tokenizer != null) {
            return tokenizer.getPlace(rest);
        }
        return null;
    }

    public String getToken(Place place) {
        PlaceTokenizer<Place> placeTokenizer = this.tokenizersByPlace.get(place.getClass());
        String token = this.prefixesByPlace.get(place.getClass());
        String rest = placeTokenizer.getToken(place);
        if (rest != null && rest.trim().length() > 0) {
            token = token + "?" + rest;
        }
        return token;
    }
}

