/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.ui.client.services;

import java.util.Map;
import org.overlord.sramp.ui.client.services.IService;
import org.overlord.sramp.ui.client.services.IServiceLifecycleListener;
import org.overlord.sramp.ui.client.services.IServices;
import org.overlord.sramp.ui.client.services.IServicesListener;
import org.overlord.sramp.ui.client.services.ServiceLifecycleContext;
import org.overlord.sramp.ui.client.services.ServiceNotFoundException;
import org.overlord.sramp.ui.client.services.i18n.ILocalizationService;
import org.overlord.sramp.ui.client.services.i18n.LocalizationService;

public class Services
implements IServices {
    private static Services services;
    private Map<Class<? extends IService>, IService> serviceMap;

    public static final IServices getServices() {
        return services;
    }

    public static void init(final Map<Class<? extends IService>, IService> registeredServices, ServiceLifecycleContext context, final IServicesListener servicesListener) {
        services = new Services(registeredServices);
        ServiceLifecycleListener lifecycleListener = new ServiceLifecycleListener(){

            @Override
            public void onStarted() {
                super.onStarted();
                if (this.getNumStarted() == registeredServices.size()) {
                    servicesListener.onAllServicesStarted();
                }
            }

            @Override
            public void onError(Throwable error) {
                servicesListener.onError(error);
            }
        };
        services.startAll(context, lifecycleListener);
    }

    private Services(Map<Class<? extends IService>, IService> registeredServices) {
        this.serviceMap = registeredServices;
    }

    private void startAll(ServiceLifecycleContext context, IServiceLifecycleListener lifecycleListener) {
        for (IService service : this.serviceMap.values()) {
            service.start(context, lifecycleListener);
        }
    }

    @Override
    public <T extends IService> T getService(Class<T> serviceType) throws ServiceNotFoundException {
        IService svc = this.serviceMap.get(serviceType);
        if (svc == null && serviceType.equals(ILocalizationService.class)) {
            svc = new LocalizationService();
        }
        if (svc != null) {
            this.serviceMap.put(serviceType, svc);
            return (T)svc;
        }
        throw new ServiceNotFoundException();
    }

    private static abstract class ServiceLifecycleListener
    implements IServiceLifecycleListener {
        private int numStarted = 0;

        @Override
        public void onStarted() {
            ++this.numStarted;
        }

        public int getNumStarted() {
            return this.numStarted;
        }
    }
}

