/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.ui.client.widgets;

import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.InlineLabel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import org.overlord.sramp.ui.client.places.ArtifactPlace;
import org.overlord.sramp.ui.client.services.Services;
import org.overlord.sramp.ui.client.services.i18n.ILocalizationService;
import org.overlord.sramp.ui.client.widgets.PlaceHyperlink;
import org.overlord.sramp.ui.client.widgets.SimpleFormLayoutPanel;
import org.overlord.sramp.ui.shared.beans.ArtifactSummary;

public class ArtifactSummaryPanel
extends FlowPanel {
    private InlineLabel noArtifactMessage;
    private SimpleFormLayoutPanel artifactForm;
    private TextBox uuidField;
    private TextBox nameField;
    private TextBox typeField;
    private TextBox createdByField;
    private TextBox createdOnField;
    private TextBox updatedOnField;
    private InlineLabel descriptionField;
    private PlaceHyperlink detailsLink;

    public ArtifactSummaryPanel() {
        ILocalizationService i18n = Services.getServices().getService(ILocalizationService.class);
        this.noArtifactMessage = new InlineLabel(i18n.translate("views.browse.summary-panel.no-artifact-message", new Object[0]));
        this.noArtifactMessage.setStyleName("message");
        this.uuidField = new TextBox();
        this.uuidField.setReadOnly(true);
        this.nameField = new TextBox();
        this.nameField.setReadOnly(true);
        this.typeField = new TextBox();
        this.typeField.setReadOnly(true);
        this.createdByField = new TextBox();
        this.createdByField.setReadOnly(true);
        this.createdOnField = new TextBox();
        this.createdOnField.setReadOnly(true);
        this.updatedOnField = new TextBox();
        this.updatedOnField.setReadOnly(true);
        this.descriptionField = new InlineLabel();
        this.detailsLink = new PlaceHyperlink(i18n.translate("views.browse.summary-panel.details-link", new Object[0]));
        this.artifactForm = new SimpleFormLayoutPanel();
        this.artifactForm.add(i18n.translate("views.browse.summary-panel.uuid-label", new Object[0]), (Widget)this.uuidField);
        this.artifactForm.add(i18n.translate("views.browse.summary-panel.name-label", new Object[0]), (Widget)this.nameField);
        this.artifactForm.add(i18n.translate("views.browse.summary-panel.type-label", new Object[0]), (Widget)this.typeField);
        this.artifactForm.add(i18n.translate("views.browse.summary-panel.created-by-label", new Object[0]), (Widget)this.createdByField);
        this.artifactForm.add(i18n.translate("views.browse.summary-panel.created-on-label", new Object[0]), (Widget)this.createdOnField);
        this.artifactForm.add(i18n.translate("views.browse.summary-panel.updated-on-label", new Object[0]), (Widget)this.updatedOnField);
        this.artifactForm.addTwoCol(null, (Widget)this.descriptionField);
        FlowPanel detailsLinkWrapper = new FlowPanel();
        detailsLinkWrapper.setStyleName("placeLinkWrapper");
        detailsLinkWrapper.add((Widget)this.detailsLink);
        this.artifactForm.addTwoCol(null, (Widget)detailsLinkWrapper);
        this.add((Widget)this.noArtifactMessage);
        this.add((Widget)this.artifactForm);
        this.getElement().addClassName("artifactSummaryPanel");
        this.reset();
    }

    public void setValue(ArtifactSummary artifact) {
        String createdOn = Services.getServices().getService(ILocalizationService.class).formatDateTime(artifact.getCreatedOn());
        String updatedOn = Services.getServices().getService(ILocalizationService.class).formatDateTime(artifact.getUpdatedOn());
        this.uuidField.setValue((Object)artifact.getUuid());
        this.nameField.setValue((Object)artifact.getName());
        this.typeField.setValue((Object)artifact.getType());
        this.createdOnField.setValue((Object)createdOn);
        this.createdByField.setValue((Object)artifact.getCreatedBy());
        this.updatedOnField.setValue((Object)updatedOn);
        this.descriptionField.setText(artifact.getDescription());
        ArtifactPlace artifactDetailsPlace = new ArtifactPlace(artifact.getModel(), artifact.getType(), artifact.getUuid());
        this.detailsLink.setTargetPlace(artifactDetailsPlace);
        this.noArtifactMessage.setVisible(false);
        this.artifactForm.setVisible(true);
    }

    public void reset() {
        this.noArtifactMessage.setVisible(true);
        this.artifactForm.setVisible(false);
        this.uuidField.setValue((Object)"");
        this.nameField.setValue((Object)"");
        this.typeField.setValue((Object)"");
        this.createdOnField.setValue((Object)"");
        this.createdByField.setValue((Object)"");
        this.updatedOnField.setValue((Object)"");
        this.descriptionField.setText("");
    }
}

