/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.ui.server.rsvcs;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import org.overlord.sramp.client.query.ArtifactSummary;
import org.overlord.sramp.client.query.QueryResultSet;
import org.overlord.sramp.common.ArtifactType;
import org.overlord.sramp.common.visitors.ArtifactVisitor;
import org.overlord.sramp.common.visitors.ArtifactVisitorHelper;
import org.overlord.sramp.ui.server.api.SrampAtomApiClient;
import org.overlord.sramp.ui.server.util.ExceptionUtils;
import org.overlord.sramp.ui.server.visitors.RelationshipVisitor;
import org.overlord.sramp.ui.shared.beans.ArtifactDetails;
import org.overlord.sramp.ui.shared.rsvcs.IArtifactRemoteService;
import org.overlord.sramp.ui.shared.rsvcs.RemoteServiceException;
import org.s_ramp.xmlns._2010.s_ramp.BaseArtifactType;
import org.s_ramp.xmlns._2010.s_ramp.Property;

public class ArtifactRemoteService
extends RemoteServiceServlet
implements IArtifactRemoteService {
    private static final long serialVersionUID = ArtifactRemoteService.class.hashCode();

    @Override
    public ArtifactDetails getArtifactDetails(String model, String type, String artifactUUID) throws RemoteServiceException {
        try {
            ArtifactType artyType = null;
            artyType = type == null ? this.resolveArtifactType(artifactUUID) : ArtifactType.valueOf((String)type);
            BaseArtifactType artifact = SrampAtomApiClient.getInstance().getArtifactMetaData(artyType, artifactUUID);
            ArtifactDetails details = new ArtifactDetails();
            details.setModel(artyType.getArtifactType().getModel());
            details.setType(artyType.getType());
            details.setUuid(artifact.getUuid());
            details.setName(artifact.getName());
            details.setDescription(artifact.getDescription());
            details.setCreatedBy(artifact.getCreatedBy());
            details.setCreatedOn(artifact.getCreatedTimestamp().toGregorianCalendar().getTime());
            details.setUpdatedOn(artifact.getLastModifiedTimestamp().toGregorianCalendar().getTime());
            details.setUpdatedBy(artifact.getLastModifiedBy());
            details.setDerived(artyType.getArtifactType().isDerived());
            for (Property property : artifact.getProperty()) {
                details.setProperty(property.getPropertyName(), property.getPropertyValue());
            }
            details.getClassifiedBy().addAll(artifact.getClassifiedBy());
            RelationshipVisitor visitor = new RelationshipVisitor(details);
            ArtifactVisitorHelper.visitArtifact((ArtifactVisitor)visitor, (BaseArtifactType)artifact);
            return details;
        }
        catch (Throwable t) {
            throw ExceptionUtils.createRemoteException(t);
        }
    }

    private ArtifactType resolveArtifactType(String artifactUUID) throws Exception {
        if (artifactUUID.contains("'")) {
            throw new Exception("Invalid UUID: " + artifactUUID);
        }
        String q = String.format("/s-ramp[@uuid = '%1$s']", artifactUUID);
        QueryResultSet resultSet = SrampAtomApiClient.getInstance().query(q);
        if (resultSet.size() == 1L) {
            ArtifactSummary summary = (ArtifactSummary)resultSet.iterator().next();
            return summary.getType();
        }
        throw new Exception("Failed to find artifact with UUID '" + artifactUUID + "'.");
    }
}

