/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.ui.server.rsvcs;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.overlord.sramp.ui.server.util.ExceptionUtils;
import org.overlord.sramp.ui.shared.rsvcs.ILocalizationRemoteService;
import org.overlord.sramp.ui.shared.rsvcs.RemoteServiceException;

public class LocalizationRemoteService
extends RemoteServiceServlet
implements ILocalizationRemoteService {
    private static final long serialVersionUID = LocalizationRemoteService.class.hashCode();

    @Override
    public Map<String, String> getMessages() throws RemoteServiceException {
        try {
            Locale locale = this.getThreadLocalRequest().getLocale();
            Properties messages = this.getMessages(locale);
            HashMap<String, String> map = new HashMap<String, String>();
            for (Map.Entry<Object, Object> entry : messages.entrySet()) {
                map.put((String)entry.getKey(), (String)entry.getValue());
            }
            return map;
        }
        catch (IOException e) {
            throw ExceptionUtils.createRemoteException(e);
        }
    }

    private Properties getMessages(Locale locale) throws IOException {
        String lang = locale.getLanguage();
        String country = locale.getCountry();
        if ("".equals(lang)) {
            lang = null;
        }
        if ("".equals(country)) {
            country = null;
        }
        Properties props = null;
        if (lang != null && country != null) {
            props = this.load("messages_" + lang + "_" + country + ".properties");
        }
        if (props == null && lang != null) {
            props = this.load("messages_" + lang + ".properties");
        }
        if (props == null) {
            props = this.load("messages.properties");
        }
        return props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties load(String messagesFileName) throws IOException {
        InputStream is;
        block3: {
            Properties properties;
            is = null;
            try {
                is = this.getClass().getClassLoader().getResourceAsStream("/META-INF/i18n/" + messagesFileName);
                if (is != null) break block3;
                properties = null;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)is);
            return properties;
        }
        Properties props = new Properties();
        props.load(is);
        Properties properties = props;
        IOUtils.closeQuietly((InputStream)is);
        return properties;
    }
}

