/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.csrfguard.session;

import jakarta.servlet.http.HttpSession;
import java.util.Objects;
import org.owasp.csrfguard.session.LogicalSession;

public class ContainerSession
implements LogicalSession {
    private final HttpSession httpSession;
    private boolean areTokensGenerated;

    public ContainerSession(HttpSession httpSession) {
        this.httpSession = httpSession;
    }

    public String getKey() {
        return this.httpSession.getId();
    }

    public boolean isNew() {
        return Objects.nonNull(this.httpSession) && this.httpSession.isNew();
    }

    public void invalidate() {
        if (Objects.nonNull(this.httpSession)) {
            this.httpSession.invalidate();
        }
    }

    public boolean areTokensGenerated() {
        return this.areTokensGenerated;
    }

    public void setTokensGenerated(boolean areTokensGenerated) {
        this.areTokensGenerated = areTokensGenerated;
    }

    public void setAttribute(String name, Object value) {
        this.httpSession.setAttribute(name, value);
    }

    public Object getAttribute(String attributeName) {
        return this.httpSession.getAttribute(attributeName);
    }
}

