/*
 * Decompiled with CFR 0.152.
 */
package org.picketbox.cdi;

import java.lang.annotation.Annotation;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import javax.inject.Named;
import org.picketbox.core.PicketBoxManager;
import org.picketbox.core.UserContext;
import org.picketbox.core.UserCredential;
import org.picketbox.core.session.DefaultSessionId;
import org.picketbox.core.session.SessionId;
import org.picketlink.authentication.AuthenticationException;
import org.picketlink.authentication.event.LoginFailedEvent;
import org.picketlink.credential.LoginCredentials;
import org.picketlink.idm.model.User;
import org.picketlink.internal.DefaultIdentity;

@SessionScoped
@Named(value="identity")
public class PicketBoxIdentity
extends DefaultIdentity {
    private static final long serialVersionUID = -290838764498141080L;
    @Inject
    private BeanManager beanManager;
    @Inject
    private LoginCredentials credential;
    @Inject
    private PicketBoxManager picketBoxManager;
    private UserContext subject;

    public boolean authenticate() throws AuthenticationException {
        return this.authenticate(null);
    }

    private boolean authenticate(String sessionId) throws AuthenticationException {
        UserContext subject = null;
        try {
            UserContext authenticationUserContext = null;
            authenticationUserContext = sessionId != null ? new UserContext((SessionId)new DefaultSessionId(sessionId)) : new UserContext();
            if (sessionId == null) {
                authenticationUserContext.setCredential((UserCredential)this.credential.getCredential());
            }
            subject = this.picketBoxManager.authenticate(authenticationUserContext);
        }
        catch (Exception e) {
            this.beanManager.fireEvent((Object)new LoginFailedEvent((Throwable)e), new Annotation[0]);
            throw new AuthenticationException(e.getMessage());
        }
        if (subject != null && subject.isAuthenticated()) {
            this.subject = subject;
            return true;
        }
        return false;
    }

    public void logout() {
        if (this.isLoggedIn()) {
            super.logout();
            this.picketBoxManager.logout(this.subject);
        }
    }

    public boolean isLoggedIn() {
        return this.subject != null && this.subject.isAuthenticated();
    }

    public User getUser() {
        return this.subject.getUser();
    }

    public boolean restoreSession(String sessionId) throws AuthenticationException {
        return this.authenticate(sessionId);
    }

    public boolean hasRole(String restrictedRole) {
        return this.isLoggedIn() && this.subject.hasRole(restrictedRole);
    }

    public UserContext getUserContext() {
        return this.subject;
    }
}

