/*
 * Decompiled with CFR 0.152.
 */
package org.picketbox.cdi;

import java.lang.annotation.Annotation;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import javax.inject.Named;
import org.jboss.picketlink.cdi.authentication.AuthenticationException;
import org.jboss.picketlink.cdi.authentication.event.LoginFailedEvent;
import org.jboss.picketlink.cdi.credential.LoginCredentials;
import org.jboss.picketlink.cdi.internal.DefaultIdentity;
import org.jboss.picketlink.idm.model.User;
import org.picketbox.cdi.PicketBoxCDISubject;
import org.picketbox.cdi.PicketBoxUser;
import org.picketbox.core.Credential;
import org.picketbox.core.PicketBoxManager;
import org.picketbox.core.PicketBoxSubject;
import org.picketbox.core.session.DefaultSessionId;

@SessionScoped
@Named(value="identity")
public class PicketBoxIdentity
extends DefaultIdentity {
    private static final long serialVersionUID = -290838764498141080L;
    @Inject
    private BeanManager beanManager;
    @Inject
    private LoginCredentials credential;
    @Inject
    private PicketBoxManager picketBoxManager;
    private PicketBoxUser user;

    public boolean authenticate() throws AuthenticationException {
        return this.authenticate(null);
    }

    private boolean authenticate(String sessionId) throws AuthenticationException {
        PicketBoxCDISubject subject = null;
        try {
            PicketBoxCDISubject authenticationSubject = new PicketBoxCDISubject(new DefaultSessionId(sessionId));
            if (sessionId == null) {
                authenticationSubject.setCredential((Credential)this.credential.getCredential().getValue());
            }
            subject = (PicketBoxCDISubject)this.picketBoxManager.authenticate((PicketBoxSubject)authenticationSubject);
        }
        catch (Exception e) {
            this.beanManager.fireEvent((Object)new LoginFailedEvent((Throwable)e), new Annotation[0]);
            throw new AuthenticationException(e.getMessage());
        }
        if (subject != null && subject.isAuthenticated()) {
            this.createUser(subject);
            return true;
        }
        return false;
    }

    public void logout() {
        if (this.isLoggedIn()) {
            super.logout();
            this.picketBoxManager.logout((PicketBoxSubject)this.user.getSubject());
            this.user = null;
        }
    }

    private void createUser(PicketBoxCDISubject subject) {
        this.user = new PicketBoxUser(subject);
    }

    public boolean isLoggedIn() {
        return this.user != null && this.user.getSubject().isAuthenticated();
    }

    public User getUser() {
        return this.user;
    }

    public boolean restoreSession(String sessionId) throws AuthenticationException {
        return this.authenticate(sessionId);
    }
}

