/*
 * Decompiled with CFR 0.152.
 */
package org.picketbox.cdi.authentication;

import java.security.Principal;
import javax.inject.Inject;
import org.jboss.picketlink.idm.IdentityManager;
import org.jboss.picketlink.idm.model.User;
import org.picketbox.core.PicketBoxPrincipal;
import org.picketbox.core.authentication.AbstractAuthenticationManager;
import org.picketbox.core.exceptions.AuthenticationException;

public class IDMAuthenticationManager
extends AbstractAuthenticationManager {
    @Inject
    private IdentityManager identityManager;

    public Principal authenticate(String username, Object credential) throws AuthenticationException {
        if (!(credential instanceof String)) {
            throw new IllegalArgumentException("IDM Authentication Manager only supports java.lang.String credentials/password.");
        }
        User user = this.identityManager.getUser(username);
        if (user != null && this.identityManager.validatePassword(user, credential.toString())) {
            return new PicketBoxPrincipal(username);
        }
        return null;
    }
}

