/*
 * Decompiled with CFR 0.152.
 */
package org.picketbox.cdi.authorization;

import javax.enterprise.context.ApplicationScoped;
import javax.interceptor.InvocationContext;
import org.apache.deltaspike.security.api.authorization.annotation.Secures;
import org.jboss.picketlink.cdi.Identity;
import org.picketbox.cdi.PicketBoxCDISubject;
import org.picketbox.cdi.PicketBoxUser;
import org.picketbox.cdi.authorization.RolesAllowed;
import org.picketbox.cdi.authorization.UserLoggedIn;
import org.picketbox.cdi.util.AnnotationUtil;

@ApplicationScoped
public class AuthorizationManager {
    @Secures
    @RolesAllowed
    public boolean restrictRoles(InvocationContext ctx, Identity identity) {
        String[] restrictedRoles;
        if (!identity.isLoggedIn()) {
            return false;
        }
        PicketBoxUser user = (PicketBoxUser)identity.getUser();
        PicketBoxCDISubject subject = user.getSubject();
        for (String restrictedRole : restrictedRoles = this.getRestrictedRoles(ctx)) {
            if (!subject.hasRole(restrictedRole)) continue;
            return true;
        }
        return false;
    }

    @Secures
    @UserLoggedIn
    public boolean isUserLoggedIn(InvocationContext ctx, Identity identity) {
        return identity.isLoggedIn();
    }

    private String[] getRestrictedRoles(InvocationContext ctx) {
        RolesAllowed restrictedRolesAnnotation = AnnotationUtil.getDeclaredAnnotation(RolesAllowed.class, ctx);
        if (restrictedRolesAnnotation != null) {
            return restrictedRolesAnnotation.value();
        }
        return new String[0];
    }
}

