/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2012, Red Hat, Inc., and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.picketbox.cdi;

import org.jboss.picketlink.idm.model.SimpleUser;
import org.jboss.picketlink.idm.model.User;
import org.picketbox.core.PicketBoxSubject;

/**
 * <p>PicketBox implementation for the {@link User} class. This class is basically a wrapper for a {@link PicketBoxSubject} instance.</p>
 *
 * @author <a href="mailto:psilva@redhat.com">Pedro Silva</a>
 *
 */
public class PicketBoxUser extends SimpleUser {

    private static final long serialVersionUID = 538628499329175561L;

    private PicketBoxCDISubject subject;

    public PicketBoxUser(PicketBoxCDISubject subject) {
        super(subject.getUser().getName());
        this.subject = subject;
    }

    public PicketBoxCDISubject getSubject() {
        return subject;
    }

    @Override
    public String getFullName() {
        if (getSubject().getIdmUser() == null) {
            return null;
        }

        return getSubject().getIdmUser().getFullName();
    }

    public boolean hasRole(String role) {
        if (getSubject() != null) {
            return getSubject().hasRole(role);
        }

        return false;
    }
}
