/*
 * Decompiled with CFR 0.152.
 */
package org.picketbox.cdi.config;

import java.lang.annotation.Annotation;
import java.util.Set;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.util.AnnotationLiteral;
import org.jboss.picketlink.idm.spi.IdentityStore;
import org.picketbox.cdi.config.CDIConfigurationBuilder;
import org.picketbox.cdi.idm.PicketLinkIdentityManager;
import org.picketbox.core.config.ConfigurationBuilder;
import org.picketbox.core.config.IdentityManagerConfigurationBuilder;
import org.picketbox.core.exceptions.ConfigurationException;
import org.picketbox.core.identity.IdentityManager;

public class CDIIdentityManagerConfigurationBuilder
extends IdentityManagerConfigurationBuilder {
    public CDIIdentityManagerConfigurationBuilder(ConfigurationBuilder builder) {
        super(builder);
    }

    public CDIIdentityManagerConfigurationBuilder providedStore() {
        IdentityStore identityStore = this.resolveIdentityStore();
        if (identityStore == null) {
            throw new ConfigurationException("No IdentityStore was provided.");
        }
        super.manager(this.resolveIdentityManager());
        return this;
    }

    private IdentityStore resolveIdentityStore() {
        Set beans = this.getBuilder().getBeanManager().getBeans(IdentityStore.class, new Annotation[]{new AnnotationLiteral<Any>(){}});
        if (beans.isEmpty()) {
            throw new ConfigurationException("JPAIdentityStore was not provided.");
        }
        Bean bean = (Bean)beans.iterator().next();
        CreationalContext createCreationalContext = this.getBuilder().getBeanManager().createCreationalContext((Contextual)bean);
        return (IdentityStore)bean.create(createCreationalContext);
    }

    private IdentityManager resolveIdentityManager() {
        Set beans = this.getBuilder().getBeanManager().getBeans(PicketLinkIdentityManager.class, new Annotation[]{new AnnotationLiteral<Any>(){}});
        if (beans.isEmpty()) {
            return null;
        }
        Bean bean = (Bean)beans.iterator().next();
        CreationalContext createCreationalContext = this.getBuilder().getBeanManager().createCreationalContext((Contextual)bean);
        return (IdentityManager)bean.create(createCreationalContext);
    }

    private CDIConfigurationBuilder getBuilder() {
        return (CDIConfigurationBuilder)this.builder;
    }
}

